/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.snappy;

import io.airlift.compress.snappy.HadoopSnappyInputStream;
import io.airlift.compress.snappy.HadoopSnappyOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DoNotPool;

public class SnappyCodec
implements Configurable,
CompressionCodec {
    private Configuration conf;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public CompressionOutputStream createOutputStream(OutputStream outputStream) throws IOException {
        return new HadoopSnappyOutputStream(outputStream, this.getBufferSize());
    }

    public CompressionOutputStream createOutputStream(OutputStream outputStream, Compressor compressor) throws IOException {
        if (!(compressor instanceof HadoopSnappyCompressor)) {
            throw new IllegalArgumentException("Compressor is not the Snappy decompressor");
        }
        return new HadoopSnappyOutputStream(outputStream, this.getBufferSize());
    }

    public Class<? extends Compressor> getCompressorType() {
        return HadoopSnappyCompressor.class;
    }

    public Compressor createCompressor() {
        return new HadoopSnappyCompressor();
    }

    public CompressionInputStream createInputStream(InputStream inputStream) throws IOException {
        return new HadoopSnappyInputStream(inputStream);
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!(decompressor instanceof HadoopSnappyDecompressor)) {
            throw new IllegalArgumentException("Decompressor is not the Snappy decompressor");
        }
        return new HadoopSnappyInputStream(in);
    }

    public Class<? extends Decompressor> getDecompressorType() {
        return HadoopSnappyDecompressor.class;
    }

    public Decompressor createDecompressor() {
        return new HadoopSnappyDecompressor();
    }

    public String getDefaultExtension() {
        return ".snappy";
    }

    private int getBufferSize() {
        int maxUncompressedLength = this.conf != null ? this.conf.getInt("io.compression.codec.snappy.buffersize", 262144) : 262144;
        return maxUncompressedLength;
    }

    @DoNotPool
    private static class HadoopSnappyDecompressor
    implements Decompressor {
        private HadoopSnappyDecompressor() {
        }

        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        public boolean needsInput() {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        public boolean needsDictionary() {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        public boolean finished() {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        public int decompress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        public void reset() {
        }

        public int getRemaining() {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }

        public void end() {
            throw new UnsupportedOperationException("Snappy block decompressor is not supported");
        }
    }

    @DoNotPool
    private static class HadoopSnappyCompressor
    implements Compressor {
        private HadoopSnappyCompressor() {
        }

        public void setInput(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        public boolean needsInput() {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        public void setDictionary(byte[] b, int off, int len) {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        public long getBytesRead() {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        public long getBytesWritten() {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        public void finish() {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        public boolean finished() {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        public int compress(byte[] b, int off, int len) throws IOException {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        public void reset() {
        }

        public void end() {
            throw new UnsupportedOperationException("Snappy block compressor is not supported");
        }

        public void reinit(Configuration conf) {
        }
    }
}

