/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;

public class SameNeighborsAPI
extends TraversersAPI {
    private static final String SAME_NEIGHBORS = "same_neighbors";

    public SameNeighborsAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "sameneighbors";
    }

    public List<Object> get(Object vertexId, Object otherId, Direction direction, String label, long degree, int limit) {
        this.client.checkApiVersion("0.51", "same neighbors");
        String vertex = GraphAPI.formatVertexId(vertexId, false);
        String other = GraphAPI.formatVertexId(otherId, false);
        SameNeighborsAPI.checkDegree(degree);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("vertex", vertex);
        params.put("other", other);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_degree", degree);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return result.readList(SAME_NEIGHBORS, Object.class);
    }
}

