/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.traverser.Ranks;
import org.apache.hugegraph.util.E;

public class PersonalRankAPI
extends TraversersAPI {
    public PersonalRankAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "personalrank";
    }

    public Ranks post(Request request) {
        RestResult result = this.client.post(this.path(), request);
        return (Ranks)result.readObject(Ranks.class);
    }

    public static class Request {
        @JsonProperty(value="source")
        private Object source;
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="alpha")
        private double alpha = 0.9;
        @JsonProperty(value="max_degree")
        public long degree = 10000L;
        @JsonProperty(value="limit")
        private int limit = 100;
        @JsonProperty(value="max_depth")
        private int maxDepth = 5;
        @JsonProperty(value="with_label")
        private WithLabel withLabel = WithLabel.BOTH_LABEL;
        @JsonProperty(value="sorted")
        private boolean sorted = true;

        public static Builder builder() {
            return new Builder();
        }

        public String toString() {
            return String.format("Request{source=%s,label=%s,alpha=%s,degree=%s,limit=%s,maxDepth=%s,withLabel=%s,sorted=%s}", new Object[]{this.source, this.label, this.alpha, this.degree, this.limit, this.maxDepth, this.withLabel, this.sorted});
        }

        public static class Builder {
            private Request request = new Request();

            private Builder() {
            }

            public Builder source(Object source) {
                E.checkArgument((source != null ? 1 : 0) != 0, (String)"The source of request for personal rank can't be null", (Object[])new Object[0]);
                this.request.source = source;
                return this;
            }

            public Builder label(String label) {
                E.checkArgument((label != null ? 1 : 0) != 0, (String)"The label of request for personal rank can't be null", (Object[])new Object[0]);
                this.request.label = label;
                return this;
            }

            public Builder alpha(double alpha) {
                TraversersAPI.checkAlpha(alpha);
                this.request.alpha = alpha;
                return this;
            }

            public Builder degree(long degree) {
                TraversersAPI.checkDegree(degree);
                this.request.degree = degree;
                return this;
            }

            public Builder limit(int limit) {
                TraversersAPI.checkLimit(limit);
                this.request.limit = limit;
                return this;
            }

            public Builder maxDepth(int maxDepth) {
                E.checkArgument((maxDepth > 0 && maxDepth <= 5000 ? 1 : 0) != 0, (String)"The max depth must be in range (0, %s], but got: %s", (Object[])new Object[]{5000, maxDepth});
                this.request.maxDepth = maxDepth;
                return this;
            }

            public Builder withLabel(WithLabel withLabel) {
                this.request.withLabel = withLabel;
                return this;
            }

            public Builder sorted(boolean sorted) {
                this.request.sorted = sorted;
                return this;
            }

            public Request build() {
                E.checkArgument((this.request.source != null ? 1 : 0) != 0, (String)"Source vertex can't be null", (Object[])new Object[0]);
                E.checkArgument((this.request.label != null ? 1 : 0) != 0, (String)"The label of rank request for personal rank can't be null", (Object[])new Object[0]);
                TraversersAPI.checkAlpha(this.request.alpha);
                TraversersAPI.checkDegree(this.request.degree);
                TraversersAPI.checkLimit(this.request.limit);
                E.checkArgument((this.request.maxDepth > 0 && this.request.maxDepth <= 5000 ? 1 : 0) != 0, (String)"The max depth must be in range (0, %s], but got: %s", (Object[])new Object[]{5000, this.request.maxDepth});
                return this.request;
            }
        }

        public static enum WithLabel {
            SAME_LABEL,
            OTHER_LABEL,
            BOTH_LABEL;

        }
    }
}

