/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConcurrentMapUtils;
import org.apache.hadoop.hbase.util.ImmutableByteArray;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class SequenceIdAccounting {
    private static final Logger LOG = LoggerFactory.getLogger(SequenceIdAccounting.class);
    private final Object tieLock = new Object();
    private final ConcurrentMap<byte[], ConcurrentMap<ImmutableByteArray, Long>> lowestUnflushedSequenceIds = new ConcurrentHashMap<byte[], ConcurrentMap<ImmutableByteArray, Long>>();
    private final Map<byte[], Map<ImmutableByteArray, Long>> flushingSequenceIds = new HashMap<byte[], Map<ImmutableByteArray, Long>>();
    private Map<byte[], Long> highestSequenceIds = new HashMap<byte[], Long>();

    SequenceIdAccounting() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getLowestSequenceId(byte[] encodedRegionName) {
        Object object = this.tieLock;
        synchronized (object) {
            Map m = this.flushingSequenceIds.get(encodedRegionName);
            long flushingLowest = m != null ? SequenceIdAccounting.getLowestSequenceId(m) : Long.MAX_VALUE;
            m = (Map)this.lowestUnflushedSequenceIds.get(encodedRegionName);
            long unflushedLowest = m != null ? SequenceIdAccounting.getLowestSequenceId(m) : -1L;
            return Math.min(flushingLowest, unflushedLowest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getLowestSequenceId(byte[] encodedRegionName, byte[] familyName) {
        ImmutableByteArray familyNameWrapper = ImmutableByteArray.wrap((byte[])familyName);
        Object object = this.tieLock;
        synchronized (object) {
            Long lowest;
            Map m = this.flushingSequenceIds.get(encodedRegionName);
            if (m != null && (lowest = m.get(familyNameWrapper)) != null) {
                return lowest;
            }
            m = (Map)this.lowestUnflushedSequenceIds.get(encodedRegionName);
            if (m != null && (lowest = (Long)m.get(familyNameWrapper)) != null) {
                return lowest;
            }
        }
        return -1L;
    }

    Map<byte[], Long> resetHighest() {
        Map<byte[], Long> old = this.highestSequenceIds;
        this.highestSequenceIds = new HashMap<byte[], Long>();
        return old;
    }

    void update(byte[] encodedRegionName, Set<byte[]> families, long sequenceid, boolean lowest) {
        Long l = sequenceid;
        this.highestSequenceIds.put(encodedRegionName, l);
        if (lowest) {
            ConcurrentMap<ImmutableByteArray, Long> m = this.getOrCreateLowestSequenceIds(encodedRegionName);
            for (byte[] familyName : families) {
                m.putIfAbsent(ImmutableByteArray.wrap((byte[])familyName), l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onRegionClose(byte[] encodedRegionName) {
        Object object = this.tieLock;
        synchronized (object) {
            this.lowestUnflushedSequenceIds.remove(encodedRegionName);
            Map<ImmutableByteArray, Long> flushing = this.flushingSequenceIds.remove(encodedRegionName);
            if (flushing != null) {
                LOG.warn("Still have flushing records when closing {}, {}", (Object)Bytes.toString((byte[])encodedRegionName), (Object)flushing.entrySet().stream().map(e -> ((ImmutableByteArray)e.getKey()).toString() + "->" + e.getValue()).collect(Collectors.joining(",", "{", "}")));
            }
        }
        this.highestSequenceIds.remove(encodedRegionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStore(byte[] encodedRegionName, byte[] familyName, Long sequenceId, boolean onlyIfGreater) {
        if (sequenceId == null) {
            return;
        }
        Long highest = this.highestSequenceIds.get(encodedRegionName);
        if (highest == null || sequenceId > highest) {
            this.highestSequenceIds.put(encodedRegionName, sequenceId);
        }
        ImmutableByteArray familyNameWrapper = ImmutableByteArray.wrap((byte[])familyName);
        Object object = this.tieLock;
        synchronized (object) {
            ConcurrentMap<ImmutableByteArray, Long> m = this.getOrCreateLowestSequenceIds(encodedRegionName);
            boolean replaced = false;
            while (!replaced) {
                Long oldSeqId = (Long)m.get(familyNameWrapper);
                if (oldSeqId == null) {
                    m.put(familyNameWrapper, sequenceId);
                    replaced = true;
                    continue;
                }
                if (onlyIfGreater) {
                    if (sequenceId > oldSeqId) {
                        replaced = m.replace(familyNameWrapper, oldSeqId, sequenceId);
                        continue;
                    }
                    return;
                }
                m.put(familyNameWrapper, sequenceId);
                return;
            }
        }
    }

    @VisibleForTesting
    ConcurrentMap<ImmutableByteArray, Long> getOrCreateLowestSequenceIds(byte[] encodedRegionName) {
        return (ConcurrentMap)ConcurrentMapUtils.computeIfAbsent(this.lowestUnflushedSequenceIds, (Object)encodedRegionName, ConcurrentHashMap::new);
    }

    private static long getLowestSequenceId(Map<?, Long> sequenceids) {
        long lowest = -1L;
        for (Long sid : sequenceids.values()) {
            if (lowest != -1L && sid >= lowest) continue;
            lowest = sid;
        }
        return lowest;
    }

    private <T extends Map<?, Long>> Map<byte[], Long> flattenToLowestSequenceId(Map<byte[], T> src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HashMap<byte[], Long> tgt = new HashMap<byte[], Long>();
        for (Map.Entry<byte[], T> entry : src.entrySet()) {
            long lowestSeqId = SequenceIdAccounting.getLowestSequenceId((Map)entry.getValue());
            if (lowestSeqId == -1L) continue;
            tgt.put(entry.getKey(), lowestSeqId);
        }
        return tgt;
    }

    Long startCacheFlush(byte[] encodedRegionName, Set<byte[]> families) {
        HashMap<byte[], Long> familytoSeq = new HashMap<byte[], Long>();
        for (byte[] familyName : families) {
            familytoSeq.put(familyName, -1L);
        }
        return this.startCacheFlush(encodedRegionName, familytoSeq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Long startCacheFlush(byte[] encodedRegionName, Map<byte[], Long> familyToSeq) {
        HashMap<ImmutableByteArray, Long> oldSequenceIds = null;
        Long lowestUnflushedInRegion = -1L;
        Object object = this.tieLock;
        synchronized (object) {
            Map m = (Map)this.lowestUnflushedSequenceIds.get(encodedRegionName);
            if (m != null) {
                for (Map.Entry<byte[], Long> entry : familyToSeq.entrySet()) {
                    ImmutableByteArray familyNameWrapper = ImmutableByteArray.wrap((byte[])entry.getKey());
                    Long seqId = null;
                    seqId = entry.getValue() == -1L ? (Long)m.remove(familyNameWrapper) : m.replace(familyNameWrapper, entry.getValue());
                    if (seqId == null) continue;
                    if (oldSequenceIds == null) {
                        oldSequenceIds = new HashMap<ImmutableByteArray, Long>();
                    }
                    oldSequenceIds.put(familyNameWrapper, seqId);
                }
                if (oldSequenceIds != null && !oldSequenceIds.isEmpty() && this.flushingSequenceIds.put(encodedRegionName, (Map<ImmutableByteArray, Long>)oldSequenceIds) != null) {
                    LOG.warn("Flushing Map not cleaned up for " + Bytes.toString((byte[])encodedRegionName) + ", sequenceid=" + oldSequenceIds);
                }
                if (m.isEmpty()) {
                    this.lowestUnflushedSequenceIds.remove(encodedRegionName);
                } else {
                    lowestUnflushedInRegion = (Long)Collections.min(m.values());
                }
            }
        }
        if (oldSequenceIds != null && oldSequenceIds.isEmpty()) {
            LOG.warn("Couldn't find oldest sequenceid for " + Bytes.toString((byte[])encodedRegionName));
        }
        return lowestUnflushedInRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeCacheFlush(byte[] encodedRegionName) {
        Object object = this.tieLock;
        synchronized (object) {
            this.flushingSequenceIds.remove(encodedRegionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortCacheFlush(byte[] encodedRegionName) {
        Map<ImmutableByteArray, Long> flushing = null;
        HashMap<ImmutableByteArray, Long> tmpMap = new HashMap<ImmutableByteArray, Long>();
        Iterator<Map.Entry<ImmutableByteArray, Long>> iterator = this.tieLock;
        synchronized (iterator) {
            flushing = this.flushingSequenceIds.remove(encodedRegionName);
            if (flushing != null) {
                ConcurrentMap<ImmutableByteArray, Long> unflushed = this.getOrCreateLowestSequenceIds(encodedRegionName);
                for (Map.Entry<ImmutableByteArray, Long> e : flushing.entrySet()) {
                    tmpMap.put(e.getKey(), unflushed.put(e.getKey(), e.getValue()));
                }
            }
        }
        if (flushing != null) {
            for (Map.Entry<ImmutableByteArray, Long> e : flushing.entrySet()) {
                Long currentId = (Long)tmpMap.get(e.getKey());
                if (currentId == null || currentId >= e.getValue()) continue;
                String errorStr = Bytes.toString((byte[])encodedRegionName) + " family " + e.getKey().toString() + " acquired edits out of order current memstore seq=" + currentId + ", previous oldest unflushed id=" + e.getValue();
                LOG.error(errorStr);
                Runtime.getRuntime().halt(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean areAllLower(Map<byte[], Long> sequenceids) {
        Map<byte[], Long> flushing = null;
        Map<byte[], Long> unflushed = null;
        Iterator<Map.Entry<byte[], Long>> iterator = this.tieLock;
        synchronized (iterator) {
            flushing = this.flattenToLowestSequenceId(this.flushingSequenceIds);
            unflushed = this.flattenToLowestSequenceId(this.lowestUnflushedSequenceIds);
        }
        for (Map.Entry<byte[], Long> e : sequenceids.entrySet()) {
            long min;
            long oldestFlushing = Long.MAX_VALUE;
            long oldestUnflushed = Long.MAX_VALUE;
            if (flushing != null && flushing.containsKey(e.getKey())) {
                oldestFlushing = flushing.get(e.getKey());
            }
            if (unflushed != null && unflushed.containsKey(e.getKey())) {
                oldestUnflushed = unflushed.get(e.getKey());
            }
            if ((min = Math.min(oldestFlushing, oldestUnflushed)) > e.getValue()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[][] findLower(Map<byte[], Long> sequenceids) {
        ArrayList<byte[]> toFlush = null;
        Object object = this.tieLock;
        synchronized (object) {
            for (Map.Entry<byte[], Long> e : sequenceids.entrySet()) {
                long lowest;
                Map m = (Map)this.lowestUnflushedSequenceIds.get(e.getKey());
                if (m == null || (lowest = SequenceIdAccounting.getLowestSequenceId(m)) == -1L || lowest > e.getValue()) continue;
                if (toFlush == null) {
                    toFlush = new ArrayList<byte[]>();
                }
                toFlush.add(e.getKey());
            }
        }
        return toFlush == null ? (byte[][])null : (byte[][])toFlush.toArray((T[])new byte[0][]);
    }
}

