/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalExplanation;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.TransformSerializer;
import org.javatuples.Pair;

public class TraversalExplanationSerializer
extends SimpleTypeSerializer<TraversalExplanation>
implements TransformSerializer<TraversalExplanation> {
    private static final String ORIGINAL = "original";
    private static final String FINAL = "final";
    private static final String INTERMEDIATE = "intermediate";
    private static final String CATEGORY = "category";
    private static final String TRAVERSAL = "traversal";
    private static final String STRATEGY = "strategy";

    public TraversalExplanationSerializer() {
        super(null);
    }

    @Override
    protected TraversalExplanation readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        throw new IOException("A TraversalExplanation should not be read individually");
    }

    @Override
    protected void writeValue(TraversalExplanation value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        throw new IOException("A TraversalExplanation should not be written individually");
    }

    @Override
    public Object transform(TraversalExplanation value) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        result.put(ORIGINAL, TraversalExplanationSerializer.getTraversalSteps(value.getOriginalTraversal()));
        List<Pair<TraversalStrategy, Traversal.Admin<?, ?>>> strategyTraversals = value.getStrategyTraversals();
        result.put(INTERMEDIATE, strategyTraversals.stream().map(pair -> {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(STRATEGY, ((TraversalStrategy)pair.getValue0()).toString());
            item.put(CATEGORY, ((TraversalStrategy)pair.getValue0()).getTraversalCategory().getSimpleName());
            item.put(TRAVERSAL, TraversalExplanationSerializer.getTraversalSteps((Traversal.Admin)pair.getValue1()));
            return item;
        }).collect(Collectors.toList()));
        result.put(FINAL, TraversalExplanationSerializer.getTraversalSteps(strategyTraversals.isEmpty() ? value.getOriginalTraversal() : (Traversal.Admin)strategyTraversals.get(strategyTraversals.size() - 1).getValue1()));
        return result;
    }

    private static List<String> getTraversalSteps(Traversal.Admin<?, ?> t) {
        return t.getSteps().stream().map(Object::toString).collect(Collectors.toList());
    }
}

