/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.binary.types;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.DataType;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.SimpleTypeSerializer;

public class InetAddressSerializer<T extends InetAddress>
extends SimpleTypeSerializer<T> {
    public InetAddressSerializer() {
        super(DataType.INETADDRESS);
    }

    @Override
    protected T readValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        int length = buffer.readInt();
        byte[] bytes = new byte[length];
        buffer.readBytes(bytes);
        try {
            return (T)InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException uhe) {
            throw new IOException("Cannot deserialize InetAddress value", uhe);
        }
    }

    @Override
    protected void writeValue(T value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        byte[] bytes = ((InetAddress)value).getAddress();
        buffer.writeInt(bytes.length).writeBytes(bytes);
    }
}

