/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.computer.core.network.MessageHandler;
import org.apache.hugegraph.computer.core.network.TransportConf;
import org.apache.hugegraph.computer.core.network.netty.HeartbeatHandler;
import org.apache.hugegraph.computer.core.network.netty.NettyClientHandler;
import org.apache.hugegraph.computer.core.network.netty.NettyServerHandler;
import org.apache.hugegraph.computer.core.network.netty.NettyTransportClient;
import org.apache.hugegraph.computer.core.network.netty.ServerIdleHandler;
import org.apache.hugegraph.computer.core.network.netty.codec.FrameDecoder;
import org.apache.hugegraph.computer.core.network.netty.codec.MessageDecoder;
import org.apache.hugegraph.computer.core.network.netty.codec.MessageEncoder;
import org.apache.hugegraph.computer.core.network.netty.codec.PreciseFrameDecoder;
import org.apache.hugegraph.computer.core.network.session.ServerSession;

public class NettyProtocol {
    private static final ChannelHandler SLOT_HANDLER = new SLOT_HANDLER();
    private static final int DISABLE_IDLE_TIME = 0;
    private static final ServerIdleHandler SERVER_IDLE_HANDLER = new ServerIdleHandler();
    private static final HeartbeatHandler HEART_BEAT_HANDLER = new HeartbeatHandler();
    protected static final String CLIENT_HANDLER_NAME = "networkClientHandler";
    protected static final String SERVER_HANDLER_NAME = "networkServerHandler";
    private final TransportConf conf;

    public NettyProtocol(TransportConf conf) {
        this.conf = conf;
    }

    protected void initializeServerPipeline(Channel channel, MessageHandler handler) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("encoder", (ChannelHandler)MessageEncoder.INSTANCE);
        if (this.conf.recvBufferFileMode()) {
            pipeline.addLast("frameDecoder", (ChannelHandler)new PreciseFrameDecoder());
            pipeline.addLast("decoder", (ChannelHandler)MessageDecoder.INSTANCE_FILE_REGION);
        } else {
            pipeline.addLast("frameDecoder", (ChannelHandler)new FrameDecoder());
            pipeline.addLast("decoder", (ChannelHandler)MessageDecoder.INSTANCE_MEMORY_BUFFER);
        }
        pipeline.addLast("serverIdleStateHandler", (ChannelHandler)this.newServerIdleStateHandler());
        pipeline.addLast("serverIdleHandler", (ChannelHandler)SERVER_IDLE_HANDLER);
        pipeline.addLast(SERVER_HANDLER_NAME, (ChannelHandler)this.newNettyServerHandler(handler));
    }

    protected void initializeClientPipeline(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("encoder", (ChannelHandler)MessageEncoder.INSTANCE);
        pipeline.addLast("frameDecoder", (ChannelHandler)new FrameDecoder());
        pipeline.addLast("decoder", (ChannelHandler)MessageDecoder.INSTANCE_MEMORY_BUFFER);
        pipeline.addLast("clientIdleStateHandler", (ChannelHandler)this.newClientIdleStateHandler());
        pipeline.addLast("heartbeatHandler", (ChannelHandler)HEART_BEAT_HANDLER);
        pipeline.addLast(CLIENT_HANDLER_NAME, SLOT_HANDLER);
        channel.attr(HeartbeatHandler.TIMEOUT_HEARTBEAT_COUNT).set((Object)0);
        channel.attr(HeartbeatHandler.MAX_TIMEOUT_HEARTBEAT_COUNT).set((Object)this.conf.maxTimeoutHeartbeatCount());
    }

    protected void replaceClientHandler(Channel channel, NettyTransportClient client) {
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.replace(CLIENT_HANDLER_NAME, CLIENT_HANDLER_NAME, (ChannelHandler)new NettyClientHandler(client));
    }

    private NettyServerHandler newNettyServerHandler(MessageHandler handler) {
        ServerSession serverSession = new ServerSession(this.conf);
        return new NettyServerHandler(serverSession, handler);
    }

    private IdleStateHandler newServerIdleStateHandler() {
        long timeout = this.conf.serverIdleTimeout();
        return new IdleStateHandler(timeout, 0L, 0L, TimeUnit.MILLISECONDS);
    }

    private IdleStateHandler newClientIdleStateHandler() {
        long interval = this.conf.heartbeatInterval();
        return new IdleStateHandler(interval, 0L, 0L, TimeUnit.MILLISECONDS);
    }

    @ChannelHandler.Sharable
    private static class SLOT_HANDLER
    extends ChannelInboundHandlerAdapter {
        private SLOT_HANDLER() {
        }
    }
}

