/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.framework;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.core5.http.HttpRequestMapper;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.impl.bootstrap.HttpServer;
import org.apache.hc.core5.http.impl.bootstrap.ServerBootstrap;
import org.apache.hc.core5.http.impl.routing.RequestRouter;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.testing.framework.ClientTestingAdapter;
import org.apache.hc.core5.testing.framework.FrameworkTest;
import org.apache.hc.core5.testing.framework.TestingFrameworkException;
import org.apache.hc.core5.testing.framework.TestingFrameworkRequestHandler;

public class TestingFramework {
    public static final List<String> ALL_METHODS = Arrays.asList("HEAD", "GET", "DELETE", "POST", "PUT", "PATCH");
    public static final Object ALREADY_CHECKED = new Object();
    public static final String DEFAULT_REQUEST_PATH = "a/path";
    public static final String DEFAULT_REQUEST_BODY = "{\"location\":\"home\"}";
    public static final String DEFAULT_REQUEST_CONTENT_TYPE = "application/json";
    public static final Map<String, String> DEFAULT_REQUEST_QUERY;
    public static final Map<String, String> DEFAULT_REQUEST_HEADERS;
    public static final ProtocolVersion DEFAULT_REQUEST_PROTOCOL_VERSION;
    public static final int DEFAULT_RESPONSE_STATUS = 200;
    public static final String DEFAULT_RESPONSE_BODY = "{\"location\":\"work\"}";
    public static final String DEFAULT_RESPONSE_CONTENT_TYPE = "application/json";
    public static final Map<String, String> DEFAULT_RESPONSE_HEADERS;
    private ClientTestingAdapter adapter;
    private TestingFrameworkRequestHandler requestHandler = new TestingFrameworkRequestHandler();
    private List<FrameworkTest> tests = new ArrayList<FrameworkTest>();
    private HttpServer server;
    private int port;

    public TestingFramework() throws TestingFrameworkException {
        this(null);
    }

    public TestingFramework(ClientTestingAdapter adapter) throws TestingFrameworkException {
        this.adapter = adapter;
        for (String method : ALL_METHODS) {
            List<Integer> statusList = Arrays.asList(200, 201);
            for (Integer status : statusList) {
                HashMap<String, String> request = new HashMap<String, String>();
                request.put("method", method);
                HashMap<String, Integer> response = new HashMap<String, Integer>();
                response.put("status", status);
                HashMap<String, Object> test = new HashMap<String, Object>();
                test.put("request", request);
                test.put("response", response);
                this.addTest(test);
            }
        }
    }

    public void setRequestHandler(TestingFrameworkRequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTests() throws TestingFrameworkException {
        if (this.adapter == null) {
            throw new TestingFrameworkException("adapter should not be null");
        }
        this.startServer();
        try {
            for (FrameworkTest test : this.tests) {
                try {
                    this.callAdapter(test);
                }
                catch (Throwable t) {
                    this.processThrowable(t, test);
                }
            }
        }
        finally {
            this.stopServer();
        }
    }

    private void processThrowable(Throwable t, FrameworkTest test) throws TestingFrameworkException {
        TestingFrameworkException e = t instanceof TestingFrameworkException ? (TestingFrameworkException)t : new TestingFrameworkException(t);
        e.setAdapter(this.adapter);
        e.setTest(test);
        throw e;
    }

    private void startServer() throws TestingFrameworkException {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(15000, TimeUnit.MILLISECONDS).build();
        ServerBootstrap serverBootstrap = ServerBootstrap.bootstrap().setSocketConfig(socketConfig).setRequestRouter((HttpRequestMapper)RequestRouter.builder().addRoute(RequestRouter.LOCAL_AUTHORITY, "*", (Object)this.requestHandler).resolveAuthority(RequestRouter.LOCAL_AUTHORITY_RESOLVER).build());
        this.server = serverBootstrap.create();
        try {
            this.server.start();
        }
        catch (IOException e) {
            throw new TestingFrameworkException(e);
        }
        this.port = this.server.getLocalPort();
    }

    private void stopServer() {
        HttpServer local = this.server;
        this.server = null;
        if (local != null) {
            local.close(CloseMode.IMMEDIATE);
        }
    }

    private void callAdapter(FrameworkTest test) throws TestingFrameworkException {
        Map<String, Object> request = test.initRequest();
        if (!this.adapter.isRequestSupported(request)) {
            return;
        }
        request = this.adapter.modifyRequest(request);
        this.requestHandler.setRequestExpectations(request);
        Map<String, Object> responseExpectations = test.initResponseExpectations();
        responseExpectations = this.adapter.modifyResponseExpectations(request, responseExpectations);
        this.requestHandler.setDesiredResponse(responseExpectations);
        String defaultURI = this.getDefaultURI();
        Map<String, Object> response = this.adapter.execute(defaultURI, request, this.requestHandler, Collections.unmodifiableMap(responseExpectations));
        this.requestHandler.assertNothingThrown();
        this.assertResponseMatchesExpectation(request.get("method"), response, responseExpectations);
    }

    private void assertResponseMatchesExpectation(Object method, Map<String, Object> actualResponse, Map<String, Object> expectedResponse) throws TestingFrameworkException {
        if (actualResponse == null) {
            throw new TestingFrameworkException("response should not be null");
        }
        if (actualResponse.get("status") != ALREADY_CHECKED) {
            this.assertStatusMatchesExpectation(actualResponse.get("status"), expectedResponse.get("status"));
        }
        if (!method.equals("HEAD")) {
            if (actualResponse.get("body") != ALREADY_CHECKED) {
                this.assertBodyMatchesExpectation(actualResponse.get("body"), expectedResponse.get("body"));
            }
            if (actualResponse.get("contentType") != ALREADY_CHECKED) {
                this.assertContentTypeMatchesExpectation(actualResponse.get("contentType"), expectedResponse.get("contentType"));
            }
        }
        if (actualResponse.get("headers") != ALREADY_CHECKED) {
            this.assertHeadersMatchExpectation((Map)actualResponse.get("headers"), (Map)expectedResponse.get("headers"));
        }
    }

    private void assertStatusMatchesExpectation(Object actualStatus, Object expectedStatus) throws TestingFrameworkException {
        if (actualStatus == null) {
            throw new TestingFrameworkException("Returned status is null.");
        }
        if (expectedStatus != null && !actualStatus.equals(expectedStatus)) {
            throw new TestingFrameworkException("Expected status not found. expected=" + expectedStatus + "; actual=" + actualStatus);
        }
    }

    private void assertBodyMatchesExpectation(Object actualBody, Object expectedBody) throws TestingFrameworkException {
        if (actualBody == null) {
            throw new TestingFrameworkException("Returned body is null.");
        }
        if (expectedBody != null && !actualBody.equals(expectedBody)) {
            throw new TestingFrameworkException("Expected body not found. expected=" + expectedBody + "; actual=" + actualBody);
        }
    }

    private void assertContentTypeMatchesExpectation(Object actualContentType, Object expectedContentType) throws TestingFrameworkException {
        if (expectedContentType != null) {
            if (actualContentType == null) {
                throw new TestingFrameworkException("Returned contentType is null.");
            }
            if (!actualContentType.equals(expectedContentType)) {
                throw new TestingFrameworkException("Expected content type not found.  expected=" + expectedContentType + "; actual=" + actualContentType);
            }
        }
    }

    private void assertHeadersMatchExpectation(Map<String, String> actualHeaders, Map<String, String> expectedHeaders) throws TestingFrameworkException {
        if (expectedHeaders == null) {
            return;
        }
        for (Map.Entry<String, String> expectedHeader : expectedHeaders.entrySet()) {
            String expectedHeaderName = expectedHeader.getKey();
            if (!actualHeaders.containsKey(expectedHeaderName)) {
                throw new TestingFrameworkException("Expected header not found: name=" + expectedHeaderName);
            }
            if (actualHeaders.get(expectedHeaderName).equals(expectedHeaders.get(expectedHeaderName))) continue;
            throw new TestingFrameworkException("Header value not expected: name=" + expectedHeaderName + "; expected=" + expectedHeaders.get(expectedHeaderName) + "; actual=" + actualHeaders.get(expectedHeaderName));
        }
    }

    private String getDefaultURI() {
        return "http://localhost:" + this.port + "/";
    }

    public void setAdapter(ClientTestingAdapter adapter) {
        this.adapter = adapter;
    }

    public void deleteTests() {
        this.tests = new ArrayList<FrameworkTest>();
    }

    public void addTest() throws TestingFrameworkException {
        this.addTest(null);
    }

    public void addTest(Map<String, Object> test) throws TestingFrameworkException {
        Map testCopy = (Map)TestingFramework.deepcopy(test);
        this.tests.add(new FrameworkTest(testCopy));
    }

    public static Object deepcopy(Object orig) throws TestingFrameworkException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(orig);
            oos.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bin);
            return ois.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new TestingFrameworkException(ex);
        }
    }

    static {
        DEFAULT_REQUEST_PROTOCOL_VERSION = HttpVersion.HTTP_1_1;
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("p1", "this");
        request.put("p2", "that");
        DEFAULT_REQUEST_QUERY = Collections.unmodifiableMap(request);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("header1", "stuff");
        headers.put("header2", "more stuff");
        DEFAULT_REQUEST_HEADERS = Collections.unmodifiableMap(headers);
        headers = new HashMap();
        headers.put("header3", "header_three");
        headers.put("header4", "header_four");
        DEFAULT_RESPONSE_HEADERS = Collections.unmodifiableMap(headers);
    }
}

