/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

/**
 * SettableStructObjectInspector.
 *
 */
public abstract class SettableStructObjectInspector extends
    StructObjectInspector {

  /**
   * Create a struct which is not null, but all its fields are null.
   */
  public abstract Object create();

  /**
   * Modify the value of a field. Returns the struct.
   */
  public abstract Object setStructFieldData(Object struct, StructField field,
      Object fieldValue);

  @Override
  public boolean isSettable() {
    return true;
  }
}
