/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase.struct;

import java.lang.reflect.Constructor;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.struct.DefaultHBaseValueFactory;
import org.apache.hadoop.hive.hbase.struct.HBaseStructValue;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazyObjectBase;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class StructHBaseValueFactory<T extends HBaseStructValue>
extends DefaultHBaseValueFactory {
    private final int fieldID;
    private final Constructor constructor;

    public StructHBaseValueFactory(int fieldID, Class<?> structValueClass) throws Exception {
        super(fieldID);
        this.fieldID = fieldID;
        this.constructor = structValueClass.getDeclaredConstructor(LazySimpleStructObjectInspector.class, Properties.class, Configuration.class, ColumnMappings.ColumnMapping.class);
    }

    @Override
    public LazyObjectBase createValueObject(ObjectInspector inspector) throws SerDeException {
        try {
            return (HBaseStructValue)((Object)this.constructor.newInstance(inspector, this.properties, this.hbaseParams.getBaseConfiguration(), this.hbaseParams.getColumnMappings().getColumnsMapping()[this.fieldID]));
        }
        catch (Exception e) {
            throw new SerDeException((Throwable)e);
        }
    }
}

