/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseMetaHook
implements HiveMetaHook,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseMetaHook.class);
    private Configuration hbaseConf;
    private Admin admin;
    private boolean isCTLT;

    public HBaseMetaHook(Configuration hbaseConf) {
        this.hbaseConf = hbaseConf;
    }

    private Admin getHBaseAdmin() throws MetaException {
        try {
            if (this.admin == null) {
                Connection conn = ConnectionFactory.createConnection((Configuration)this.hbaseConf);
                this.admin = conn.getAdmin();
            }
            return this.admin;
        }
        catch (IOException ioe) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ioe));
        }
    }

    private String getHBaseTableName(Table tbl) {
        String tableName = (String)tbl.getParameters().get("hbase.table.name");
        if (tableName == null && (tableName = (String)tbl.getSd().getSerdeInfo().getParameters().get("hbase.table.name")) != null) {
            tableName = tableName.toLowerCase();
        }
        if (tableName == null && (tableName = (tbl.getDbName() + "." + tbl.getTableName()).toLowerCase()).startsWith("default.")) {
            tableName = tableName.substring("default.".length());
        }
        return tableName;
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table tbl, boolean deleteData) throws MetaException {
        try {
            boolean isPurge;
            String tableName = this.getHBaseTableName(tbl);
            boolean bl = isPurge = !MetaStoreUtils.isExternalTable((Table)tbl) || MetaStoreUtils.isExternalTablePurge((Table)tbl);
            if (deleteData && isPurge) {
                LOG.info("Dropping with purge all the data for data source {}", (Object)tableName);
                if (this.getHBaseAdmin().tableExists(TableName.valueOf((String)tableName))) {
                    if (this.getHBaseAdmin().isTableEnabled(TableName.valueOf((String)tableName))) {
                        this.getHBaseAdmin().disableTable(TableName.valueOf((String)tableName));
                    }
                    this.getHBaseAdmin().deleteTable(TableName.valueOf((String)tableName));
                }
            }
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preCreateTable(Table tbl) throws MetaException {
        if (tbl.getSd().getLocation() != null) {
            throw new MetaException("LOCATION may not be specified for HBase.");
        }
        this.isCTLT = Optional.ofNullable(tbl.getParameters()).map(params -> (String)params.get("created_with_ctlt")).map(Boolean::parseBoolean).orElse(false);
        org.apache.hadoop.hbase.client.Table htable = null;
        try {
            HTableDescriptor tableDesc;
            String tableName = this.getHBaseTableName(tbl);
            Map serdeParam = tbl.getSd().getSerdeInfo().getParameters();
            String hbaseColumnsMapping = (String)serdeParam.get("hbase.columns.mapping");
            ColumnMappings columnMappings = HBaseSerDe.parseColumnsMapping(hbaseColumnsMapping);
            if (!this.getHBaseAdmin().tableExists(TableName.valueOf((String)tableName))) {
                tableDesc = new HTableDescriptor(TableName.valueOf((String)tableName));
                HashSet<String> uniqueColumnFamilies = new HashSet<String>();
                for (ColumnMappings.ColumnMapping colMap : columnMappings) {
                    if (colMap.hbaseRowKey || colMap.hbaseTimestamp) continue;
                    uniqueColumnFamilies.add(colMap.familyName);
                }
                for (String columnFamily : uniqueColumnFamilies) {
                    tableDesc.addFamily(new HColumnDescriptor(Bytes.toBytes((String)columnFamily)));
                }
                this.getHBaseAdmin().createTable((TableDescriptor)tableDesc);
            } else {
                tableDesc = this.getHBaseAdmin().getTableDescriptor(TableName.valueOf((String)tableName));
                for (ColumnMappings.ColumnMapping colMap : columnMappings) {
                    if (colMap.hbaseRowKey || colMap.hbaseTimestamp || tableDesc.hasFamily(colMap.familyNameBytes)) continue;
                    throw new MetaException("Column Family " + colMap.familyName + " is not defined in hbase table " + tableName);
                }
            }
            htable = this.getHBaseAdmin().getConnection().getTable(tableDesc.getTableName());
            if (htable == null) return;
        }
        catch (Exception se) {
            try {
                throw new MetaException(StringUtils.stringifyException((Throwable)se));
            }
            catch (Throwable throwable) {
                if (htable == null) throw throwable;
                IOUtils.closeQuietly(htable);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)htable);
        return;
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        String tableName = this.getHBaseTableName(table);
        boolean isPurge = !MetaStoreUtils.isExternalTable((Table)table) || MetaStoreUtils.isExternalTablePurge((Table)table);
        try {
            if (isPurge && this.getHBaseAdmin().tableExists(TableName.valueOf((String)tableName)) && !this.isCTLT) {
                if (this.getHBaseAdmin().isTableEnabled(TableName.valueOf((String)tableName))) {
                    this.getHBaseAdmin().disableTable(TableName.valueOf((String)tableName));
                }
                this.getHBaseAdmin().deleteTable(TableName.valueOf((String)tableName));
            }
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    @Override
    public void close() throws IOException {
        if (this.admin != null) {
            Connection connection = this.admin.getConnection();
            this.admin.close();
            this.admin = null;
            if (connection != null) {
                connection.close();
            }
        }
    }
}

