/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.storage.jdbc.spitter;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.storage.jdbc.spitter.IntervalSplitter;

public class TimestampIntervalSplitter
implements IntervalSplitter {
    @Override
    public List<MutablePair<String, String>> getIntervals(String lowerBound, String upperBound, int numPartitions, TypeInfo typeInfo) {
        ArrayList<MutablePair<String, String>> intervals = new ArrayList<MutablePair<String, String>>();
        Timestamp timestampLower = Timestamp.valueOf(lowerBound);
        Timestamp timestampUpper = Timestamp.valueOf(upperBound);
        double timestampInterval = (double)(timestampUpper.getTime() - timestampLower.getTime()) / (double)numPartitions;
        for (int i = 0; i < numPartitions; ++i) {
            Timestamp splitTimestampUpper;
            Timestamp splitTimestampLower = new Timestamp(Math.round((double)timestampLower.getTime() + timestampInterval * (double)i));
            if (splitTimestampLower.compareTo(splitTimestampUpper = new Timestamp(Math.round((double)timestampLower.getTime() + timestampInterval * (double)(i + 1)))) >= 0) continue;
            intervals.add((MutablePair<String, String>)new MutablePair((Object)splitTimestampLower.toString(), (Object)splitTimestampUpper.toString()));
        }
        return intervals;
    }
}

