/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.exim;

import com.google.common.base.Function;
import java.util.Collections;
import org.apache.hive.hcatalog.api.HCatNotificationEvent;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationTask;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.api.repl.commands.DropDatabaseCommand;
import org.apache.hive.hcatalog.api.repl.commands.NoopCommand;
import org.apache.hive.hcatalog.messaging.DropDatabaseMessage;

public class DropDatabaseReplicationTask
extends ReplicationTask {
    private DropDatabaseMessage dropDatabaseMessage = null;

    public DropDatabaseReplicationTask(HCatNotificationEvent event) {
        super(event);
        this.validateEventType(event, "DROP_DATABASE");
        this.dropDatabaseMessage = messageFactory.getDeserializer().getDropDatabaseMessage(event.getMessage());
    }

    @Override
    public boolean needsStagingDirs() {
        return false;
    }

    @Override
    public Iterable<? extends Command> getSrcWhCommands() {
        this.verifyActionable();
        return Collections.singletonList(new NoopCommand(this.event.getEventId()));
    }

    @Override
    public Iterable<? extends Command> getDstWhCommands() {
        this.verifyActionable();
        String dstDbName = ReplicationUtils.mapIfMapAvailable(this.dropDatabaseMessage.getDB(), (Function<String, String>)this.dbNameMapping);
        return Collections.singletonList(new DropDatabaseCommand(dstDbName, this.event.getEventId()));
    }
}

