/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.api.repl.commands;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.hcatalog.api.repl.Command;
import org.apache.hive.hcatalog.api.repl.ReplicationUtils;
import org.apache.hive.hcatalog.data.ReaderWriter;

public class ExportCommand
implements Command {
    private String exportLocation;
    private String dbName = null;
    private String tableName = null;
    private Map<String, String> ptnDesc = null;
    private long eventId;
    private boolean isMetadataOnly = false;

    public ExportCommand(String dbName, String tableName, Map<String, String> ptnDesc, String exportLocation, boolean isMetadataOnly, long eventId) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.ptnDesc = ptnDesc;
        this.exportLocation = exportLocation;
        this.isMetadataOnly = isMetadataOnly;
        this.eventId = eventId;
    }

    public ExportCommand() {
    }

    @Override
    public List<String> get() {
        StringBuilder sb = new StringBuilder();
        sb.append("EXPORT TABLE ");
        sb.append(this.dbName);
        sb.append(".");
        sb.append(this.tableName);
        sb.append(ReplicationUtils.partitionDescriptor(this.ptnDesc));
        sb.append(" TO '");
        sb.append(this.exportLocation);
        sb.append("' FOR ");
        if (this.isMetadataOnly) {
            sb.append("METADATA ");
        }
        sb.append("REPLICATION('");
        sb.append(this.eventId);
        sb.append("')");
        return Collections.singletonList(sb.toString());
    }

    @Override
    public boolean isRetriable() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public List<String> getUndo() {
        return Collections.emptyList();
    }

    @Override
    public List<String> cleanupLocationsPerRetry() {
        return Collections.singletonList(this.exportLocation);
    }

    @Override
    public List<String> cleanupLocationsAfterEvent() {
        return Collections.singletonList(this.exportLocation);
    }

    @Override
    public long getEventId() {
        return this.eventId;
    }

    public void write(DataOutput dataOutput) throws IOException {
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.dbName);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.tableName);
        ReaderWriter.writeDatum((DataOutput)dataOutput, this.ptnDesc);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.exportLocation);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.isMetadataOnly);
        ReaderWriter.writeDatum((DataOutput)dataOutput, (Object)this.eventId);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.dbName = (String)ReaderWriter.readDatum((DataInput)dataInput);
        this.tableName = (String)ReaderWriter.readDatum((DataInput)dataInput);
        this.ptnDesc = (Map)ReaderWriter.readDatum((DataInput)dataInput);
        this.exportLocation = (String)ReaderWriter.readDatum((DataInput)dataInput);
        this.isMetadataOnly = (Boolean)ReaderWriter.readDatum((DataInput)dataInput);
        this.eventId = (Long)ReaderWriter.readDatum((DataInput)dataInput);
    }
}

