/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.accumulo;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class AccumuloHiveRow
implements Writable {
    private String rowId;
    private List<ColumnTuple> tuples = new ArrayList<ColumnTuple>();

    public AccumuloHiveRow() {
    }

    public AccumuloHiveRow(String rowId) {
        this.rowId = rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public List<ColumnTuple> getTuples() {
        return Collections.unmodifiableList(this.tuples);
    }

    public boolean hasFamAndQual(Text fam, Text qual) {
        for (ColumnTuple tuple : this.tuples) {
            if (!tuple.getCf().equals((Object)fam) || !tuple.getCq().equals((Object)qual)) continue;
            return true;
        }
        return false;
    }

    public byte[] getValue(Text fam, Text qual) {
        for (ColumnTuple tuple : this.tuples) {
            if (!tuple.getCf().equals((Object)fam) || !tuple.getCq().equals((Object)qual)) continue;
            return tuple.getValue();
        }
        return null;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void clear() {
        this.rowId = null;
        this.tuples = new ArrayList<ColumnTuple>();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("AccumuloHiveRow{");
        builder.append("rowId='").append(this.rowId).append("', tuples: ");
        for (ColumnTuple tuple : this.tuples) {
            builder.append(tuple.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof AccumuloHiveRow) {
            AccumuloHiveRow other = (AccumuloHiveRow)o;
            if (null == this.rowId ? null != other.rowId : !this.rowId.equals(other.rowId)) {
                return false;
            }
            return this.tuples.equals(other.tuples);
        }
        return false;
    }

    public void write(DataOutput dataOutput) throws IOException {
        if (null != this.rowId) {
            dataOutput.writeBoolean(true);
            dataOutput.writeUTF(this.rowId);
        } else {
            dataOutput.writeBoolean(false);
        }
        int size = this.tuples.size();
        dataOutput.writeInt(size);
        for (ColumnTuple tuple : this.tuples) {
            Text cf = tuple.getCf();
            Text cq = tuple.getCq();
            dataOutput.writeInt(cf.getLength());
            dataOutput.write(cf.getBytes(), 0, cf.getLength());
            dataOutput.writeInt(cq.getLength());
            dataOutput.write(cq.getBytes(), 0, cq.getLength());
            byte[] value = tuple.getValue();
            dataOutput.writeInt(value.length);
            dataOutput.write(value);
        }
    }

    public void readFields(DataInput dataInput) throws IOException {
        if (dataInput.readBoolean()) {
            this.rowId = dataInput.readUTF();
        }
        int size = dataInput.readInt();
        for (int i = 0; i < size; ++i) {
            int cfLength = dataInput.readInt();
            byte[] cfData = new byte[cfLength];
            dataInput.readFully(cfData, 0, cfLength);
            Text cf = new Text(cfData);
            int cqLength = dataInput.readInt();
            byte[] cqData = new byte[cqLength];
            dataInput.readFully(cqData, 0, cqLength);
            Text cq = new Text(cqData);
            int valSize = dataInput.readInt();
            byte[] val = new byte[valSize];
            for (int j = 0; j < valSize; ++j) {
                val[j] = dataInput.readByte();
            }
            this.tuples.add(new ColumnTuple(cf, cq, val));
        }
    }

    public void add(String cf, String qual, byte[] val) {
        Preconditions.checkNotNull((Object)cf);
        Preconditions.checkNotNull((Object)qual);
        Preconditions.checkNotNull((Object)val);
        this.add(new Text(cf), new Text(qual), val);
    }

    public void add(Text cf, Text qual, byte[] val) {
        Preconditions.checkNotNull((Object)cf);
        Preconditions.checkNotNull((Object)qual);
        Preconditions.checkNotNull((Object)val);
        this.tuples.add(new ColumnTuple(cf, qual, val));
    }

    public static class ColumnTuple {
        private final Text cf;
        private final Text cq;
        private final byte[] value;

        public ColumnTuple(Text cf, Text cq, byte[] value) {
            this.value = value;
            this.cf = cf;
            this.cq = cq;
        }

        public byte[] getValue() {
            return this.value;
        }

        public Text getCf() {
            return this.cf;
        }

        public Text getCq() {
            return this.cq;
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder(9683, 68783);
            return hcb.append((Object)this.cf).append((Object)this.cq).append(this.value).toHashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ColumnTuple) {
                ColumnTuple other = (ColumnTuple)o;
                if (null == this.cf ? null != other.cf : !this.cf.equals((Object)other.cf)) {
                    return false;
                }
                if (null == this.cq ? null != other.cq : !this.cq.equals((Object)other.cq)) {
                    return false;
                }
                if (null == this.value && null != other.value) {
                    return false;
                }
                return Arrays.equals(this.value, other.value);
            }
            return false;
        }

        public String toString() {
            return this.cf + " " + this.cq + " " + new String(this.value);
        }
    }
}

