/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.schema;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ldaptive.LdapUtils;
import org.ldaptive.schema.AbstractSchemaElement;
import org.ldaptive.schema.Extensions;
import org.ldaptive.schema.SchemaUtils;

public class Syntax
extends AbstractSchemaElement {
    private static final int HASH_CODE_SEED = 1129;
    private static final Pattern DEFINITION_PATTERN = Pattern.compile("[ ]*\\([ ]*([^ ]+)[ ]*(?:DESC '([^']+)')?[ ]*(?:(X-[^ ]+.*))?[ ]*\\)[ ]*");
    private final String oid;

    public Syntax(String s) {
        this.oid = s;
    }

    public Syntax(String oid, String description, Extensions extensions) {
        this(oid);
        this.setDescription(description);
        this.setExtensions(extensions);
    }

    public String getOID() {
        return this.oid;
    }

    public static Syntax parse(String definition) throws ParseException {
        Matcher m = DEFINITION_PATTERN.matcher(definition);
        if (!m.matches()) {
            throw new ParseException("Invalid attribute syntax definition: " + definition, definition.length());
        }
        Syntax asd = new Syntax(m.group(1).trim());
        asd.setDescription(m.group(2) != null ? m.group(2).trim() : null);
        if (m.group(3) != null) {
            asd.setExtensions(Extensions.parse(m.group(3).trim()));
        }
        return asd;
    }

    @Override
    public String format() {
        StringBuilder sb = new StringBuilder("( ");
        sb.append(this.oid).append(" ");
        if (this.getDescription() != null) {
            sb.append("DESC ");
            sb.append(SchemaUtils.formatDescriptors(this.getDescription()));
        }
        if (this.getExtensions() != null) {
            sb.append(this.getExtensions().format());
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Syntax) {
            Syntax v = (Syntax)o;
            return LdapUtils.areEqual(this.oid, v.oid) && LdapUtils.areEqual(this.getDescription(), v.getDescription()) && LdapUtils.areEqual(this.getExtensions(), v.getExtensions());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return LdapUtils.computeHashCode(1129, this.oid, this.getDescription(), this.getExtensions());
    }

    public String toString() {
        return String.format("[%s@%d::oid=%s, description=%s, extensions=%s]", this.getClass().getName(), this.hashCode(), this.oid, this.getDescription(), this.getExtensions());
    }
}

