/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.tools.json;

import java.io.PrintStream;
import java.util.Objects;
import org.apache.orc.TypeDescription;
import org.apache.orc.tools.json.HiveType;

public class MapType
extends HiveType {
    private final HiveType keyType;
    private final HiveType valueType;

    MapType(HiveType keyType, HiveType valueType) {
        super(HiveType.Kind.MAP);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public String toString() {
        return "map<" + String.valueOf(this.keyType) + "," + String.valueOf(this.valueType) + ">";
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.keyType.equals(((MapType)o).keyType) && this.valueType.equals(((MapType)o).valueType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyType, this.valueType);
    }

    @Override
    public boolean subsumes(HiveType other) {
        return other.kind == HiveType.Kind.MAP && this.keyType.subsumes(((MapType)other).keyType) && this.valueType.subsumes(((MapType)other).valueType) || other.kind == HiveType.Kind.NULL;
    }

    @Override
    public void merge(HiveType other) {
        if (other.getClass() == MapType.class) {
            MapType otherMap = (MapType)other;
            this.keyType.merge(otherMap.keyType);
            this.valueType.merge(otherMap.valueType);
        }
    }

    @Override
    public void printFlat(PrintStream out, String prefix) {
        prefix = (String)prefix + ".";
        this.keyType.printFlat(out, (String)prefix + "key");
        this.keyType.printFlat(out, (String)prefix + "value");
    }

    @Override
    public TypeDescription getSchema() {
        return TypeDescription.createMap((TypeDescription)this.keyType.getSchema(), (TypeDescription)this.valueType.getSchema());
    }
}

