/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.data.schema;

import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatSchema;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HCatFieldSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    String fieldName = null;
    String comment = null;
    Type type = null;
    Category category = null;
    HCatSchema subSchema = null;
    @Deprecated
    Type mapKeyType = null;
    private String typeString = null;
    private PrimitiveTypeInfo typeInfo;
    private PrimitiveTypeInfo mapKeyTypeInfo;

    public boolean isComplex() {
        return this.category != Category.PRIMITIVE;
    }

    private HCatFieldSchema() {
    }

    public Type getType() {
        return this.type;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getName() {
        return this.fieldName;
    }

    public String getComment() {
        return this.comment;
    }

    public PrimitiveTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public HCatFieldSchema(String fieldName, Type type, String comment) throws HCatException {
        HCatFieldSchema.assertTypeInCategory(type, Category.PRIMITIVE, fieldName);
        this.fieldName = fieldName;
        this.type = type;
        this.category = Category.PRIMITIVE;
        this.comment = comment;
    }

    public HCatFieldSchema(String fieldName, PrimitiveTypeInfo typeInfo, String comment) throws HCatException {
        this.fieldName = fieldName;
        this.category = Category.PRIMITIVE;
        this.typeInfo = typeInfo;
        if (typeInfo == null) {
            throw new IllegalArgumentException("typeInfo cannot be null; fieldName=" + fieldName);
        }
        this.type = Type.getPrimitiveHType(typeInfo);
        this.comment = comment;
    }

    public HCatFieldSchema(String fieldName, Type type, HCatSchema subSchema, String comment) throws HCatException {
        HCatFieldSchema.assertTypeNotInCategory(type, Category.PRIMITIVE);
        HCatFieldSchema.assertTypeNotInCategory(type, Category.MAP);
        this.fieldName = fieldName;
        this.type = type;
        this.category = Category.fromType(type);
        this.subSchema = subSchema;
        if (type == Type.ARRAY) {
            this.subSchema.get(0).setName(null);
        }
        this.comment = comment;
    }

    private void setName(String name) {
        this.fieldName = name;
    }

    public HCatFieldSchema(String fieldName, Type type, Type mapKeyType, HCatSchema mapValueSchema, String comment) throws HCatException {
        HCatFieldSchema.assertTypeInCategory(type, Category.MAP, fieldName);
        HCatFieldSchema.assertTypeInCategory(mapKeyType, Category.PRIMITIVE, fieldName);
        this.fieldName = fieldName;
        this.type = Type.MAP;
        this.category = Category.MAP;
        this.mapKeyType = mapKeyType;
        this.subSchema = mapValueSchema;
        this.subSchema.get(0).setName(null);
        this.comment = comment;
    }

    public static HCatFieldSchema createMapTypeFieldSchema(String fieldName, PrimitiveTypeInfo mapKeyType, HCatSchema mapValueSchema, String comment) throws HCatException {
        HCatFieldSchema mapSchema = new HCatFieldSchema(fieldName, Type.MAP, Type.getPrimitiveHType(mapKeyType), mapValueSchema, comment);
        mapSchema.mapKeyTypeInfo = mapKeyType;
        return mapSchema;
    }

    public HCatSchema getStructSubSchema() throws HCatException {
        HCatFieldSchema.assertTypeInCategory(this.type, Category.STRUCT, this.fieldName);
        return this.subSchema;
    }

    public HCatSchema getArrayElementSchema() throws HCatException {
        HCatFieldSchema.assertTypeInCategory(this.type, Category.ARRAY, this.fieldName);
        return this.subSchema;
    }

    public Type getMapKeyType() throws HCatException {
        HCatFieldSchema.assertTypeInCategory(this.type, Category.MAP, this.fieldName);
        return this.mapKeyType;
    }

    public PrimitiveTypeInfo getMapKeyTypeInfo() throws HCatException {
        HCatFieldSchema.assertTypeInCategory(this.type, Category.MAP, this.fieldName);
        return this.mapKeyTypeInfo;
    }

    public HCatSchema getMapValueSchema() throws HCatException {
        HCatFieldSchema.assertTypeInCategory(this.type, Category.MAP, this.fieldName);
        return this.subSchema;
    }

    private static void assertTypeInCategory(Type type, Category category, String fieldName) throws HCatException {
        Category typeCategory = Category.fromType(type);
        if (typeCategory != category) {
            throw new HCatException("Type category mismatch. Expected " + category + " but type " + type + " in category " + typeCategory + " (field " + fieldName + ")");
        }
    }

    private static void assertTypeNotInCategory(Type type, Category category) throws HCatException {
        Category typeCategory = Category.fromType(type);
        if (typeCategory == category) {
            throw new HCatException("Type category mismatch. Expected type " + type + " not in category " + category + " but was so.");
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("fieldName", (Object)this.fieldName).append("comment", (Object)this.comment).append("type", (Object)this.getTypeString()).append("category", (Object)this.category).toString();
    }

    public String getTypeString() {
        if (this.typeString != null) {
            return this.typeString;
        }
        StringBuilder sb = new StringBuilder();
        if (!this.isComplex()) {
            sb.append(this.typeInfo == null ? this.type : this.typeInfo.getTypeName());
        } else if (Category.STRUCT == this.category) {
            sb.append("struct<");
            sb.append(this.subSchema.getSchemaAsTypeString());
            sb.append(">");
        } else if (Category.ARRAY == this.category) {
            sb.append("array<");
            sb.append(this.subSchema.getSchemaAsTypeString());
            sb.append(">");
        } else if (Category.MAP == this.category) {
            sb.append("map<");
            sb.append(this.mapKeyTypeInfo == null ? this.mapKeyType : this.mapKeyTypeInfo.getTypeName());
            sb.append(",");
            sb.append(this.subSchema.getSchemaAsTypeString());
            sb.append(">");
        }
        this.typeString = sb.toString().toLowerCase();
        return this.typeString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HCatFieldSchema)) {
            return false;
        }
        HCatFieldSchema other = (HCatFieldSchema)obj;
        if (this.category != other.category) {
            return false;
        }
        if (this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName)) {
            return false;
        }
        return !(this.getTypeString() == null ? other.getTypeString() != null : !this.getTypeString().equals(other.getTypeString()));
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        result = 31 * result + (this.getTypeString() == null ? 0 : this.getTypeString().hashCode());
        return result;
    }

    public static enum Category {
        PRIMITIVE,
        ARRAY,
        MAP,
        STRUCT;


        public static Category fromType(Type type) {
            if (Type.ARRAY == type) {
                return ARRAY;
            }
            if (Type.STRUCT == type) {
                return STRUCT;
            }
            if (Type.MAP == type) {
                return MAP;
            }
            return PRIMITIVE;
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type BOOLEAN = new Type(PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN);
        public static final /* enum */ Type TINYINT = new Type(PrimitiveObjectInspector.PrimitiveCategory.BYTE);
        public static final /* enum */ Type SMALLINT = new Type(PrimitiveObjectInspector.PrimitiveCategory.SHORT);
        public static final /* enum */ Type INT = new Type(PrimitiveObjectInspector.PrimitiveCategory.INT);
        public static final /* enum */ Type BIGINT = new Type(PrimitiveObjectInspector.PrimitiveCategory.LONG);
        public static final /* enum */ Type FLOAT = new Type(PrimitiveObjectInspector.PrimitiveCategory.FLOAT);
        public static final /* enum */ Type DOUBLE = new Type(PrimitiveObjectInspector.PrimitiveCategory.DOUBLE);
        public static final /* enum */ Type DECIMAL = new Type(PrimitiveObjectInspector.PrimitiveCategory.DECIMAL);
        public static final /* enum */ Type STRING = new Type(PrimitiveObjectInspector.PrimitiveCategory.STRING);
        public static final /* enum */ Type CHAR = new Type(PrimitiveObjectInspector.PrimitiveCategory.CHAR);
        public static final /* enum */ Type VARCHAR = new Type(PrimitiveObjectInspector.PrimitiveCategory.VARCHAR);
        public static final /* enum */ Type BINARY = new Type(PrimitiveObjectInspector.PrimitiveCategory.BINARY);
        public static final /* enum */ Type DATE = new Type(PrimitiveObjectInspector.PrimitiveCategory.DATE);
        public static final /* enum */ Type TIMESTAMP = new Type(PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP);
        public static final /* enum */ Type ARRAY = new Type(ObjectInspector.Category.LIST);
        public static final /* enum */ Type MAP = new Type(ObjectInspector.Category.MAP);
        public static final /* enum */ Type STRUCT = new Type(ObjectInspector.Category.STRUCT);
        private final ObjectInspector.Category category;
        private final PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(ObjectInspector.Category cat) {
            this.category = cat;
            this.primitiveCategory = null;
            assert (this.category != ObjectInspector.Category.PRIMITIVE) : "This c'tor should be used for complex category types";
        }

        private Type(PrimitiveObjectInspector.PrimitiveCategory primCat) {
            this.category = ObjectInspector.Category.PRIMITIVE;
            this.primitiveCategory = primCat;
        }

        public ObjectInspector.Category getCategory() {
            return this.category;
        }

        public PrimitiveObjectInspector.PrimitiveCategory getPrimitiveCategory() {
            return this.primitiveCategory;
        }

        public static Type getPrimitiveHType(PrimitiveTypeInfo basePrimitiveTypeInfo) {
            for (Type t : Type.values()) {
                if (t.getPrimitiveCategory() != basePrimitiveTypeInfo.getPrimitiveCategory()) continue;
                return t;
            }
            throw new TypeNotPresentException(basePrimitiveTypeInfo.getTypeName(), null);
        }

        public static int numPrimitiveTypes() {
            int numPrimitives = 0;
            for (Type t : Type.values()) {
                if (t.category != ObjectInspector.Category.PRIMITIVE) continue;
                ++numPrimitives;
            }
            return numPrimitives;
        }

        private static /* synthetic */ Type[] $values() {
            return new Type[]{BOOLEAN, TINYINT, SMALLINT, INT, BIGINT, FLOAT, DOUBLE, DECIMAL, STRING, CHAR, VARCHAR, BINARY, DATE, TIMESTAMP, ARRAY, MAP, STRUCT};
        }

        static {
            $VALUES = Type.$values();
        }
    }
}

