/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.query.inmemory.method;

import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;
import org.datanucleus.store.query.expression.VariableExpression;
import org.datanucleus.store.query.inmemory.InMemoryExpressionEvaluator;
import org.datanucleus.store.query.inmemory.InvocationEvaluator;
import org.datanucleus.store.query.inmemory.VariableNotSetException;
import org.datanucleus.util.Localiser;

public class MapContainsEntryMethod
implements InvocationEvaluator {
    @Override
    public Object evaluate(InvokeExpression expr, Object invokedValue, InMemoryExpressionEvaluator eval) {
        Object currentValForKey;
        String method = expr.getOperation();
        if (invokedValue == null) {
            return Boolean.FALSE;
        }
        if (!(invokedValue instanceof Map)) {
            throw new NucleusException(Localiser.msg("021011", method, invokedValue.getClass().getName()));
        }
        Expression keyParam = expr.getArguments().get(0);
        Expression valParam = expr.getArguments().get(1);
        Object keyValue = null;
        if (keyParam instanceof Literal) {
            keyValue = ((Literal)keyParam).getLiteral();
        } else if (keyParam instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)keyParam;
            keyValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (keyParam instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)keyParam;
            keyValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (keyParam instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)keyParam;
            try {
                keyValue = eval.getValueForVariableExpression(varExpr);
            }
            catch (VariableNotSetException vnse) {
                throw new VariableNotSetException(varExpr, ((Map)invokedValue).values().toArray());
            }
        } else {
            throw new NucleusException("Dont currently support use of containsEntry(" + keyParam.getClass().getName() + ",?)");
        }
        Object valValue = null;
        if (valParam instanceof Literal) {
            valValue = ((Literal)valParam).getLiteral();
        } else if (keyParam instanceof PrimaryExpression) {
            PrimaryExpression primExpr = (PrimaryExpression)valParam;
            valValue = eval.getValueForPrimaryExpression(primExpr);
        } else if (keyParam instanceof ParameterExpression) {
            ParameterExpression paramExpr = (ParameterExpression)valParam;
            valValue = QueryUtils.getValueForParameterExpression(eval.getParameterValues(), paramExpr);
        } else if (keyParam instanceof VariableExpression) {
            VariableExpression varExpr = (VariableExpression)valParam;
            try {
                valValue = eval.getValueForVariableExpression(varExpr);
            }
            catch (VariableNotSetException vnse) {
                throw new VariableNotSetException(varExpr, ((Map)invokedValue).values().toArray());
            }
        } else {
            throw new NucleusException("Dont currently support use of containsEntry(?," + valParam.getClass().getName() + ")");
        }
        Map invokedMap = (Map)invokedValue;
        if (invokedMap.containsKey(keyValue) && (currentValForKey = invokedMap.get(keyValue)).equals(valValue)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

