/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store;

import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.state.DNStateManager;

public interface StorePersistenceHandler {
    public void close();

    default public void batchStart(ExecutionContext ec, PersistenceBatchType batchType) {
    }

    default public void batchEnd(ExecutionContext ec, PersistenceBatchType type) {
    }

    public void insertObject(DNStateManager var1);

    default public void insertObjects(DNStateManager ... sms) {
        if (sms.length == 1) {
            this.insertObject(sms[0]);
            return;
        }
        for (int i = 0; i < sms.length; ++i) {
            this.insertObject(sms[i]);
        }
    }

    public void updateObject(DNStateManager var1, int[] var2);

    public void deleteObject(DNStateManager var1);

    default public void deleteObjects(DNStateManager ... sms) {
        if (sms.length == 1) {
            this.deleteObject(sms[0]);
            return;
        }
        for (int i = 0; i < sms.length; ++i) {
            this.deleteObject(sms[i]);
        }
    }

    public void fetchObject(DNStateManager var1, int[] var2);

    default public void fetchObjects(int[] fieldNumbers, DNStateManager ... sms) {
        for (DNStateManager sm : sms) {
            this.fetchObject(sm, fieldNumbers);
        }
    }

    public void locateObject(DNStateManager var1);

    default public void locateObjects(DNStateManager[] sms) {
        if (sms.length == 1) {
            this.locateObject(sms[0]);
            return;
        }
        for (int i = 0; i < sms.length; ++i) {
            this.locateObject(sms[i]);
        }
    }

    public Object findObject(ExecutionContext var1, Object var2);

    default public Object[] findObjects(ExecutionContext ec, Object[] ids) {
        Object[] objects = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            objects[i] = this.findObject(ec, ids[i]);
        }
        return objects;
    }

    public Object findObjectForUnique(ExecutionContext var1, AbstractClassMetaData var2, String[] var3, Object[] var4);

    public static enum PersistenceBatchType {
        PERSIST,
        DELETE,
        LOCATE;

    }
}

