/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation.hplsql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.hplsql.executor.ColumnMeta;
import org.apache.hive.hplsql.executor.Metadata;
import org.apache.hive.hplsql.executor.QueryException;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.apache.hive.hplsql.executor.QueryResult;
import org.apache.hive.hplsql.executor.RowResult;
import org.apache.hive.service.cli.ColumnDescriptor;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.FetchType;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationHandle;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.session.HiveSession;

public class HplSqlQueryExecutor
implements QueryExecutor {
    public static final String QUERY_EXECUTOR = "QUERY_EXECUTOR";
    public static final String HPLSQL = "HPLSQL";
    private final HiveSession hiveSession;
    private final long fetchSize;

    public HplSqlQueryExecutor(HiveSession hiveSession) {
        this.fetchSize = hiveSession.getHiveConf().getIntVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_DEFAULT_FETCH_SIZE);
        this.hiveSession = hiveSession;
    }

    public QueryResult executeQuery(String sql, ParserRuleContext ctx) {
        try {
            HashMap<String, String> confOverlay = new HashMap<String, String>();
            confOverlay.put(QUERY_EXECUTOR, HPLSQL);
            OperationHandle operationHandle = this.hiveSession.executeStatement(sql, confOverlay);
            return new QueryResult((RowResult)new OperationRowResult(operationHandle), () -> this.metadata(operationHandle), null);
        }
        catch (HiveSQLException e) {
            return new QueryResult(null, () -> new Metadata(Collections.emptyList()), (Exception)e);
        }
    }

    public Metadata metadata(OperationHandle operationHandle) {
        try {
            ArrayList<ColumnMeta> colMeta = new ArrayList<ColumnMeta>();
            if (operationHandle.hasResultSet()) {
                TableSchema meta = this.hiveSession.getResultSetMetadata(operationHandle);
                for (int i = 0; i < meta.getSize(); ++i) {
                    ColumnDescriptor col = meta.getColumnDescriptorAt(i);
                    colMeta.add(new ColumnMeta(col.getName(), col.getTypeName(), col.getType().toJavaSQLType()));
                }
            }
            return new Metadata(colMeta);
        }
        catch (HiveSQLException e) {
            throw new QueryException((Throwable)e);
        }
    }

    private class OperationRowResult
    implements RowResult {
        private final OperationHandle handle;
        private RowSet rows;
        private Iterator<Object[]> iterator;
        private Object[] current;

        private OperationRowResult(OperationHandle operationHandle) {
            this.handle = operationHandle;
        }

        public boolean next() {
            if (this.rows == null || !this.iterator.hasNext()) {
                this.rows = this.fetch();
                this.iterator = this.rows.iterator();
            }
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return true;
            }
            this.current = null;
            return false;
        }

        private RowSet fetch() {
            try {
                return HplSqlQueryExecutor.this.hiveSession.fetchResults(this.handle, FetchOrientation.FETCH_NEXT, HplSqlQueryExecutor.this.fetchSize, FetchType.QUERY_OUTPUT);
            }
            catch (HiveSQLException e) {
                throw new QueryException((Throwable)e);
            }
        }

        public <T> T get(int columnIndex, Class<T> type) {
            if (this.current[columnIndex] == null) {
                return null;
            }
            if (type.isInstance(this.current[columnIndex])) {
                return (T)this.current[columnIndex];
            }
            if (this.current[columnIndex] instanceof Number) {
                if (type == Long.class) {
                    return type.cast(((Number)this.current[columnIndex]).longValue());
                }
                if (type == Integer.class) {
                    return type.cast(((Number)this.current[columnIndex]).intValue());
                }
                if (type == Short.class) {
                    return type.cast(((Number)this.current[columnIndex]).shortValue());
                }
                if (type == Byte.class) {
                    return type.cast(((Number)this.current[columnIndex]).byteValue());
                }
                if (type == String.class) {
                    return (T)String.valueOf(this.current[columnIndex]);
                }
            }
            if (type == BigDecimal.class && "decimal".equalsIgnoreCase(HplSqlQueryExecutor.this.metadata(this.handle).columnTypeName(columnIndex))) {
                return (T)new BigDecimal((String)this.current[columnIndex]);
            }
            throw new ClassCastException(this.current[columnIndex].getClass() + " cannot be casted to " + type);
        }

        public void close() {
            try {
                HplSqlQueryExecutor.this.hiveSession.closeOperation(this.handle);
            }
            catch (HiveSQLException e) {
                throw new QueryException((Throwable)e);
            }
        }
    }
}

