/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.common.security.authenticator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.apache.kafkaesque.common.config.ConfigException;
import org.apache.kafkaesque.common.config.types.Password;
import org.apache.kafkaesque.common.network.ListenerName;
import org.apache.kafkaesque.common.security.JaasContext;
import org.apache.kafkaesque.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafkaesque.common.security.auth.Login;
import org.apache.kafkaesque.common.security.authenticator.AbstractLogin;
import org.apache.kafkaesque.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredLoginCallbackHandler;
import org.apache.kafkaesque.common.utils.SecurityUtils;
import org.apache.kafkaesque.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoginManager.class);
    private static final Map<LoginMetadata<String>, LoginManager> STATIC_INSTANCES = new HashMap<LoginMetadata<String>, LoginManager>();
    private static final Map<LoginMetadata<Password>, LoginManager> DYNAMIC_INSTANCES = new HashMap<LoginMetadata<Password>, LoginManager>();
    private final Login login;
    private final LoginMetadata<?> loginMetadata;
    private final AuthenticateCallbackHandler loginCallbackHandler;
    private int refCount;

    private LoginManager(JaasContext jaasContext, String saslMechanism, Map<String, ?> configs, LoginMetadata<?> loginMetadata) throws LoginException {
        this.loginMetadata = loginMetadata;
        this.login = Utils.newInstance(loginMetadata.loginClass);
        this.loginCallbackHandler = Utils.newInstance(loginMetadata.loginCallbackClass);
        this.loginCallbackHandler.configure(configs, saslMechanism, jaasContext.configurationEntries());
        this.login.configure(configs, jaasContext.name(), jaasContext.configuration(), this.loginCallbackHandler);
        this.login.login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginManager acquireLoginManager(JaasContext jaasContext, String saslMechanism, Class<? extends Login> defaultLoginClass, Map<String, ?> configs) throws LoginException {
        Class<? extends Login> loginClass = LoginManager.configuredClassOrDefault(configs, jaasContext, saslMechanism, "sasl.login.class", defaultLoginClass);
        Class defaultLoginCallbackHandlerClass = "OAUTHBEARER".equals(saslMechanism) ? OAuthBearerUnsecuredLoginCallbackHandler.class : AbstractLogin.DefaultLoginCallbackHandler.class;
        Class<OAuthBearerUnsecuredLoginCallbackHandler> loginCallbackClass = LoginManager.configuredClassOrDefault(configs, jaasContext, saslMechanism, "sasl.login.callback.handler.class", defaultLoginCallbackHandlerClass);
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            LoginManager loginManager;
            Password jaasConfigValue = jaasContext.dynamicJaasConfig();
            if (jaasConfigValue != null) {
                LoginMetadata<Password> loginMetadata = new LoginMetadata<Password>(jaasConfigValue, loginClass, loginCallbackClass);
                loginManager = DYNAMIC_INSTANCES.get(loginMetadata);
                if (loginManager == null) {
                    loginManager = new LoginManager(jaasContext, saslMechanism, configs, loginMetadata);
                    DYNAMIC_INSTANCES.put(loginMetadata, loginManager);
                }
            } else {
                LoginMetadata<String> loginMetadata = new LoginMetadata<String>(jaasContext.name(), loginClass, loginCallbackClass);
                loginManager = STATIC_INSTANCES.get(loginMetadata);
                if (loginManager == null) {
                    loginManager = new LoginManager(jaasContext, saslMechanism, configs, loginMetadata);
                    STATIC_INSTANCES.put(loginMetadata, loginManager);
                }
            }
            SecurityUtils.addConfiguredSecurityProviders(configs);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return loginManager.acquire();
        }
    }

    public Subject subject() {
        return this.login.subject();
    }

    public String serviceName() {
        return this.login.serviceName();
    }

    Object cacheKey() {
        return this.loginMetadata.configInfo;
    }

    private LoginManager acquire() {
        ++this.refCount;
        LOGGER.trace("{} acquired", (Object)this);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            if (this.refCount == 0) {
                throw new IllegalStateException("release() called on disposed " + this);
            }
            if (this.refCount == 1) {
                if (this.loginMetadata.configInfo instanceof Password) {
                    DYNAMIC_INSTANCES.remove(this.loginMetadata);
                } else {
                    STATIC_INSTANCES.remove(this.loginMetadata);
                }
                this.login.close();
                this.loginCallbackHandler.close();
            }
            --this.refCount;
            LOGGER.trace("{} released", (Object)this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String toString() {
        return "LoginManager(serviceName=" + this.serviceName() + ", publicCredentials=" + this.subject().getPublicCredentials() + ", refCount=" + this.refCount + ')';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            for (LoginMetadata<String> loginMetadata : new ArrayList<LoginMetadata<String>>(STATIC_INSTANCES.keySet())) {
                LoginManager.STATIC_INSTANCES.remove(loginMetadata).login.close();
            }
            for (LoginMetadata<Object> loginMetadata : new ArrayList<LoginMetadata<Password>>(DYNAMIC_INSTANCES.keySet())) {
                LoginManager.DYNAMIC_INSTANCES.remove(loginMetadata).login.close();
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    private static <T> Class<? extends T> configuredClassOrDefault(Map<String, ?> configs, JaasContext jaasContext, String saslMechanism, String configName, Class<? extends T> defaultClass) {
        String prefix = jaasContext.type() == JaasContext.Type.SERVER ? ListenerName.saslMechanismPrefix(saslMechanism) : "";
        Class<? extends T> clazz = (Class<? extends T>)configs.get(prefix + configName);
        if (clazz != null && jaasContext.configurationEntries().size() != 1) {
            String errorMessage = configName + " cannot be specified with multiple login modules in the JAAS context. " + "sasl.jaas.config" + " must be configured to override mechanism-specific configs.";
            throw new ConfigException(errorMessage);
        }
        if (clazz == null) {
            clazz = defaultClass;
        }
        return clazz;
    }

    private static class LoginMetadata<T> {
        final T configInfo;
        final Class<? extends Login> loginClass;
        final Class<? extends AuthenticateCallbackHandler> loginCallbackClass;

        LoginMetadata(T configInfo, Class<? extends Login> loginClass, Class<? extends AuthenticateCallbackHandler> loginCallbackClass) {
            this.configInfo = configInfo;
            this.loginClass = loginClass;
            this.loginCallbackClass = loginCallbackClass;
        }

        public int hashCode() {
            return Objects.hash(this.configInfo, this.loginClass, this.loginCallbackClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LoginMetadata loginMetadata = (LoginMetadata)o;
            return Objects.equals(this.configInfo, loginMetadata.configInfo) && Objects.equals(this.loginClass, loginMetadata.loginClass) && Objects.equals(this.loginCallbackClass, loginMetadata.loginCallbackClass);
        }
    }
}

