/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesque.clients.consumer.internals;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafkaesque.clients.consumer.internals.AsyncClient;
import org.apache.kafkaesque.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafkaesque.clients.consumer.internals.SubscriptionState;
import org.apache.kafkaesque.common.Node;
import org.apache.kafkaesque.common.TopicPartition;
import org.apache.kafkaesque.common.errors.TopicAuthorizationException;
import org.apache.kafkaesque.common.protocol.Errors;
import org.apache.kafkaesque.common.requests.AbstractRequest;
import org.apache.kafkaesque.common.requests.EpochEndOffset;
import org.apache.kafkaesque.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafkaesque.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafkaesque.common.utils.LogContext;

public class OffsetsForLeaderEpochClient
extends AsyncClient<Map<TopicPartition, SubscriptionState.FetchPosition>, OffsetsForLeaderEpochRequest, OffsetsForLeaderEpochResponse, OffsetForEpochResult> {
    OffsetsForLeaderEpochClient(ConsumerNetworkClient client, LogContext logContext) {
        super(client, logContext);
    }

    @Override
    protected AbstractRequest.Builder<OffsetsForLeaderEpochRequest> prepareRequest(Node node, Map<TopicPartition, SubscriptionState.FetchPosition> requestData) {
        HashMap<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitionData = new HashMap<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData>(requestData.size());
        requestData.forEach((topicPartition, fetchPosition) -> fetchPosition.offsetEpoch.ifPresent(fetchEpoch -> partitionData.put((TopicPartition)topicPartition, new OffsetsForLeaderEpochRequest.PartitionData(fetchPosition.currentLeader.epoch, (int)fetchEpoch))));
        return OffsetsForLeaderEpochRequest.Builder.forConsumer(partitionData);
    }

    @Override
    protected OffsetForEpochResult handleResponse(Node node, Map<TopicPartition, SubscriptionState.FetchPosition> requestData, OffsetsForLeaderEpochResponse response) {
        HashSet<TopicPartition> partitionsToRetry = new HashSet<TopicPartition>();
        HashSet<String> unauthorizedTopics = new HashSet<String>();
        HashMap<TopicPartition, EpochEndOffset> endOffsets = new HashMap<TopicPartition, EpochEndOffset>();
        block7: for (TopicPartition topicPartition : requestData.keySet()) {
            EpochEndOffset epochEndOffset = response.responses().get(topicPartition);
            if (epochEndOffset == null) {
                this.logger().warn("Missing partition {} from response, ignoring", (Object)topicPartition);
                partitionsToRetry.add(topicPartition);
                continue;
            }
            Errors error = epochEndOffset.error();
            switch (error) {
                case NONE: {
                    this.logger().debug("Handling OffsetsForLeaderEpoch response for {}. Got offset {} for epoch {}", new Object[]{topicPartition, epochEndOffset.endOffset(), epochEndOffset.leaderEpoch()});
                    endOffsets.put(topicPartition, epochEndOffset);
                    continue block7;
                }
                case NOT_LEADER_FOR_PARTITION: 
                case REPLICA_NOT_AVAILABLE: 
                case KAFKA_STORAGE_ERROR: 
                case OFFSET_NOT_AVAILABLE: 
                case LEADER_NOT_AVAILABLE: {
                    this.logger().debug("Attempt to fetch offsets for partition {} failed due to {}, retrying.", (Object)topicPartition, (Object)error);
                    partitionsToRetry.add(topicPartition);
                    continue block7;
                }
                case FENCED_LEADER_EPOCH: 
                case UNKNOWN_LEADER_EPOCH: {
                    this.logger().debug("Attempt to fetch offsets for partition {} failed due to {}, retrying.", (Object)topicPartition, (Object)error);
                    partitionsToRetry.add(topicPartition);
                    continue block7;
                }
                case UNKNOWN_TOPIC_OR_PARTITION: {
                    this.logger().warn("Received unknown topic or partition error in ListOffset request for partition {}", (Object)topicPartition);
                    partitionsToRetry.add(topicPartition);
                    continue block7;
                }
                case TOPIC_AUTHORIZATION_FAILED: {
                    unauthorizedTopics.add(topicPartition.topic());
                    continue block7;
                }
            }
            this.logger().warn("Attempt to fetch offsets for partition {} failed due to: {}, retrying.", (Object)topicPartition, (Object)error.message());
            partitionsToRetry.add(topicPartition);
        }
        if (!unauthorizedTopics.isEmpty()) {
            throw new TopicAuthorizationException(unauthorizedTopics);
        }
        return new OffsetForEpochResult(endOffsets, partitionsToRetry);
    }

    public static class OffsetForEpochResult {
        private final Map<TopicPartition, EpochEndOffset> endOffsets;
        private final Set<TopicPartition> partitionsToRetry;

        OffsetForEpochResult(Map<TopicPartition, EpochEndOffset> endOffsets, Set<TopicPartition> partitionsNeedingRetry) {
            this.endOffsets = endOffsets;
            this.partitionsToRetry = partitionsNeedingRetry;
        }

        public Map<TopicPartition, EpochEndOffset> endOffsets() {
            return this.endOffsets;
        }

        public Set<TopicPartition> partitionsToRetry() {
            return this.partitionsToRetry;
        }
    }
}

