/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.wadl.doclet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import jdk.javadoc.doclet.DocletEnvironment;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ClassDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.MethodDocType;
import org.glassfish.jersey.server.wadl.internal.generators.resourcedoc.model.ParamDocType;
import org.glassfish.jersey.wadl.doclet.DocProcessor;

public class DocProcessorWrapper
implements DocProcessor {
    private final List<DocProcessor> _docProcessors = new ArrayList<DocProcessor>();

    void add(DocProcessor docProcessor) {
        this._docProcessors.add(docProcessor);
    }

    @Override
    public Class<?>[] getRequiredJaxbContextClasses() {
        ArrayList result = new ArrayList();
        for (DocProcessor docProcessor : this._docProcessors) {
            Class<?>[] requiredJaxbContextClasses = docProcessor.getRequiredJaxbContextClasses();
            if (requiredJaxbContextClasses == null || requiredJaxbContextClasses.length <= 0) continue;
            result.addAll(Arrays.asList(requiredJaxbContextClasses));
        }
        return result.toArray(new Class[result.size()]);
    }

    @Override
    public String[] getCDataElements() {
        ArrayList<String> result = new ArrayList<String>();
        for (DocProcessor docProcessor : this._docProcessors) {
            String[] cdataElements = docProcessor.getCDataElements();
            if (cdataElements == null || cdataElements.length <= 0) continue;
            result.addAll(Arrays.asList(cdataElements));
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void processClassDoc(TypeElement classDoc, ClassDocType classDocType) {
        for (DocProcessor docProcessor : this._docProcessors) {
            docProcessor.processClassDoc(classDoc, classDocType);
        }
    }

    @Override
    public void processMethodDoc(ExecutableElement methodDoc, MethodDocType methodDocType) {
        for (DocProcessor docProcessor : this._docProcessors) {
            docProcessor.processMethodDoc(methodDoc, methodDocType);
        }
    }

    @Override
    public void processParamTag(VariableElement parameter, ParamDocType paramDocType) {
        for (DocProcessor docProcessor : this._docProcessors) {
            docProcessor.processParamTag(parameter, paramDocType);
        }
    }

    @Override
    public void processClassDocWithDocEnv(TypeElement classDoc, ClassDocType classDocType, DocletEnvironment docEnv) {
        for (DocProcessor docProcessor : this._docProcessors) {
            docProcessor.processClassDocWithDocEnv(classDoc, classDocType, docEnv);
        }
    }

    @Override
    public void processMethodDocWithDocEnv(ExecutableElement methodDoc, MethodDocType methodDocType, DocletEnvironment docEnv) {
        for (DocProcessor docProcessor : this._docProcessors) {
            docProcessor.processMethodDocWithDocEnv(methodDoc, methodDocType, docEnv);
        }
    }

    @Override
    public void processParamTagWithDocEnv(VariableElement parameter, ParamDocType paramDocType, DocletEnvironment docEnv) {
        for (DocProcessor docProcessor : this._docProcessors) {
            docProcessor.processParamTagWithDocEnv(parameter, paramDocType, docEnv);
        }
    }
}

