/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import org.apache.hadoop.hive.common.cli.EscapeCRLFHelper;
import org.apache.hive.beeline.BeeLine;

abstract class Rows
implements Iterator {
    protected final BeeLine beeLine;
    final ResultSetMetaData rsMeta;
    final Boolean[] primaryKeys;
    final NumberFormat numberFormat;
    private boolean convertBinaryArrayToString;
    private final String nullStr;

    Rows(BeeLine beeLine, ResultSet rs) throws SQLException {
        this.beeLine = beeLine;
        this.nullStr = beeLine.getOpts().getNullString();
        this.rsMeta = rs.getMetaData();
        int count = this.rsMeta.getColumnCount();
        this.primaryKeys = new Boolean[count];
        this.numberFormat = beeLine.getOpts().getNumberFormat().equals("default") ? null : new DecimalFormat(beeLine.getOpts().getNumberFormat());
        this.convertBinaryArrayToString = beeLine.getOpts().getConvertBinaryArrayToString();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    abstract void normalizeWidths();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isPrimaryKey(int col) {
        block8: {
            if (this.primaryKeys[col] == null) {
                try {
                    String table = this.rsMeta.getTableName(col + 1);
                    String column = this.rsMeta.getColumnName(col + 1);
                    if (table == null || table.isEmpty() || column == null || column.isEmpty()) {
                        this.primaryKeys[col] = Boolean.FALSE;
                        break block8;
                    }
                    this.primaryKeys[col] = Boolean.FALSE;
                    try (ResultSet pks = this.beeLine.getDatabaseConnection().getDatabaseMetaData().getPrimaryKeys(this.beeLine.getDatabaseConnection().getDatabaseMetaData().getConnection().getCatalog(), null, table);){
                        while (pks.next()) {
                            if (!column.equalsIgnoreCase(pks.getString("COLUMN_NAME"))) continue;
                            this.primaryKeys[col] = Boolean.TRUE;
                            break;
                        }
                    }
                }
                catch (SQLException sqle) {
                    this.primaryKeys[col] = Boolean.FALSE;
                }
            }
        }
        return this.primaryKeys[col];
    }

    class Row {
        final String[] values;
        final boolean isMeta;
        boolean deleted;
        boolean inserted;
        boolean updated;
        int[] sizes;

        Row(int size) throws SQLException {
            this.isMeta = true;
            this.values = new String[size];
            this.sizes = new int[size];
            for (int i = 0; i < size; ++i) {
                this.values[i] = Rows.this.rsMeta.getColumnLabel(i + 1);
                this.sizes[i] = this.values[i] == null ? 1 : this.values[i].length();
            }
            this.deleted = false;
            this.updated = false;
            this.inserted = false;
        }

        public String toString() {
            return Arrays.asList(this.values).toString();
        }

        Row(int size, ResultSet rs) throws SQLException {
            this.isMeta = false;
            this.values = new String[size];
            this.sizes = new int[size];
            try {
                this.deleted = rs.rowDeleted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.updated = rs.rowUpdated();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.inserted = rs.rowInserted();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (int i = 0; i < size; ++i) {
                Object o = rs.getObject(i + 1);
                String value = null;
                value = o == null ? Rows.this.nullStr : (o instanceof Number ? (Rows.this.numberFormat != null ? Rows.this.numberFormat.format(o) : (o instanceof BigDecimal ? ((BigDecimal)o).toPlainString() : o.toString())) : (o instanceof byte[] ? (Rows.this.convertBinaryArrayToString ? new String((byte[])o, StandardCharsets.UTF_8) : Base64.getEncoder().withoutPadding().encodeToString((byte[])o)) : rs.getString(i + 1)));
                if (Rows.this.beeLine.getOpts().getEscapeCRLF()) {
                    value = EscapeCRLFHelper.escapeCRLF((String)value);
                }
                this.values[i] = value.intern();
                this.sizes[i] = value.length();
            }
        }
    }
}

