/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.api.jdo.state;

import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.state.LifeCycleState;
import org.datanucleus.transaction.Transaction;
import org.datanucleus.util.Localiser;

class PersistentDirty
extends LifeCycleState {
    protected PersistentDirty() {
        this.isPersistent = true;
        this.isDirty = true;
        this.isNew = false;
        this.isDeleted = false;
        this.isTransactional = true;
        this.stateType = 3;
    }

    public LifeCycleState transitionDeletePersistent(DNStateManager sm) {
        sm.clearLoadedFlags();
        return this.changeState(sm, 8);
    }

    public LifeCycleState transitionMakeNontransactional(DNStateManager sm) {
        throw new NucleusUserException(Localiser.msg((String)"027011"), sm.getInternalObjectId());
    }

    public LifeCycleState transitionMakeTransient(DNStateManager sm, boolean useFetchPlan, boolean detachAllOnCommit) {
        if (detachAllOnCommit) {
            return this.changeState(sm, 0);
        }
        throw new NucleusUserException(Localiser.msg((String)"027012"), sm.getInternalObjectId());
    }

    public LifeCycleState transitionCommit(DNStateManager sm, Transaction tx) {
        sm.clearSavedFields();
        if (tx.getRetainValues()) {
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionRollback(DNStateManager sm, Transaction tx) {
        if (tx.getRestoreValues()) {
            sm.restoreFields();
            return this.changeState(sm, 9);
        }
        sm.clearNonPrimaryKeyFields();
        sm.clearSavedFields();
        return this.changeState(sm, 4);
    }

    public LifeCycleState transitionRefresh(DNStateManager sm) {
        sm.clearSavedFields();
        sm.refreshFieldsInFetchPlan();
        sm.unloadNonFetchPlanFields();
        Transaction tx = sm.getExecutionContext().getTransaction();
        if (tx.isActive() && !tx.getOptimistic()) {
            return this.changeState(sm, 2);
        }
        return this.changeState(sm, 9);
    }

    public LifeCycleState transitionDetach(DNStateManager sm) {
        return this.changeState(sm, 11);
    }

    public String toString() {
        return "P_DIRTY";
    }
}

