/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.MetaWrapperException;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class GetDatabaseIdHandler
implements QueryHandler<Long> {
    private final String database;
    private final String catalog;

    public GetDatabaseIdHandler(String database, String catalog) {
        this.database = database;
        this.catalog = catalog;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "SELECT \"DB_ID\" FROM \"DBS\" WHERE \"NAME\" = :database AND \"CTLG_NAME\" = :catalog";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("database", (Object)this.database).addValue("catalog", (Object)this.catalog);
    }

    public Long extractData(ResultSet rs) throws SQLException {
        if (!rs.next()) {
            throw new MetaWrapperException(new MetaException("DB with name " + this.database + " does not exist in catalog " + this.catalog));
        }
        return rs.getLong(1);
    }
}

