/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CheckFailedCompactionsHandler
implements QueryHandler<Boolean> {
    private final Configuration conf;
    private final CompactionInfo ci;

    public CheckFailedCompactionsHandler(Configuration conf, CompactionInfo ci) {
        this.conf = conf;
        this.ci = ci;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        return "SELECT \"CC_STATE\", \"CC_ENQUEUE_TIME\" FROM \"COMPLETED_COMPACTIONS\" WHERE \"CC_DATABASE\" = :dbName AND \"CC_TABLE\" = :tableName AND (:partName IS NULL OR \"CC_PARTITION\" = :partName) AND \"CC_STATE\" != :state ORDER BY \"CC_ID\" DESC";
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return new MapSqlParameterSource().addValue("state", (Object)Character.toString('a'), 1).addValue("dbName", (Object)this.ci.dbname).addValue("tableName", (Object)this.ci.tableName).addValue("partName", (Object)this.ci.partName, 12);
    }

    public Boolean extractData(ResultSet rs) throws SQLException, DataAccessException {
        int numFailed = 0;
        int numTotal = 0;
        long lastEnqueueTime = -1L;
        int failedThreshold = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
        while (rs.next() && ++numTotal <= failedThreshold) {
            long enqueueTime = rs.getLong(2);
            if (enqueueTime > lastEnqueueTime) {
                lastEnqueueTime = enqueueTime;
            }
            if (rs.getString(1).charAt(0) == 'f') {
                ++numFailed;
                continue;
            }
            --numFailed;
        }
        long retryTime = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_RETRY_TIME, (TimeUnit)TimeUnit.MILLISECONDS);
        boolean needsRetry = retryTime > 0L && lastEnqueueTime + retryTime < System.currentTimeMillis();
        return numFailed == failedThreshold && !needsRetry;
    }
}

