/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CleanTxnToWriteIdTableFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(CleanTxnToWriteIdTableFunction.class);
    private static String minHistoryLevelSql = "SELECT MIN(\"RES\".\"ID\") AS \"ID\" FROM ( SELECT MAX(\"TXN_ID\") + 1 AS \"ID\" FROM \"TXNS\"   UNION SELECT MIN(\"TXN_ID\") AS \"ID\" FROM \"TXNS\" WHERE \"TXN_STATE\" = :abortedState) \"RES\"";
    private static String noMinHistoryLevelSql = "SELECT MIN(\"RES\".\"ID\") AS \"ID\" FROM ( SELECT MAX(\"TXN_ID\") + 1 AS \"ID\" FROM \"TXNS\"   UNION SELECT MIN(\"WS_TXNID\") AS \"ID\" FROM \"WRITE_SET\"   UNION SELECT MIN(\"TXN_ID\") AS \"ID\" FROM \"TXNS\" WHERE \"TXN_STATE\" = " + TxnStatus.ABORTED + "   OR \"TXN_STATE\" = " + TxnStatus.OPEN + " ) \"RES\"";
    private final long minTxnIdSeenOpen;

    public CleanTxnToWriteIdTableFunction(long minTxnIdSeenOpen) {
        this.minTxnIdSeenOpen = minTxnIdSeenOpen;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        Long minTxnId;
        NamedParameterJdbcTemplate jdbcTemplate = jdbcResource.getJdbcTemplate();
        String sql = TxnHandler.ConfVars.useMinHistoryLevel() ? minHistoryLevelSql : noMinHistoryLevelSql;
        MapSqlParameterSource params = new MapSqlParameterSource().addValue("abortedState", (Object)TxnStatus.ABORTED.getSqlConst(), 1);
        if (!TxnHandler.ConfVars.useMinHistoryLevel()) {
            params.addValue("openState", (Object)TxnStatus.OPEN.getSqlConst(), 1);
        }
        if ((minTxnId = (Long)jdbcTemplate.query(sql, (SqlParameterSource)params, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return null;
        })) == null) {
            throw new MetaException("Transaction tables not properly initialized, no record found in TXNS");
        }
        long minUncommitedTxnid = Math.min(minTxnId, this.minTxnIdSeenOpen);
        int rc = jdbcTemplate.update("DELETE FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_TXNID\" < :txnId", (SqlParameterSource)new MapSqlParameterSource("txnId", (Object)minUncommitedTxnid));
        LOG.info("Removed {} rows from TXN_TO_WRITE_ID with Txn Low-Water-Mark: {}", (Object)rc, (Object)minUncommitedTxnid);
        return null;
    }
}

