/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.OperationType;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedBatchCommand;
import org.apache.hadoop.hive.metastore.txn.jdbc.ParameterizedCommand;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.springframework.jdbc.core.ParameterizedPreparedStatementSetter;

public class InsertTxnComponentsCommand
implements ParameterizedBatchCommand<Object[]> {
    private final LockRequest lockRequest;
    private final Map<Pair<String, String>, Long> writeIds;
    private final AddDynamicPartitions dynamicPartitions;

    public InsertTxnComponentsCommand(LockRequest lockRequest, Map<Pair<String, String>, Long> writeIds) {
        this.lockRequest = lockRequest;
        this.writeIds = writeIds;
        this.dynamicPartitions = null;
    }

    public InsertTxnComponentsCommand(AddDynamicPartitions dynamicPartitions) {
        this.dynamicPartitions = dynamicPartitions;
        this.lockRequest = null;
        this.writeIds = null;
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) {
        return "INSERT INTO \"TXN_COMPONENTS\" (\"TC_TXNID\", \"TC_DATABASE\", \"TC_TABLE\", \"TC_PARTITION\", \"TC_OPERATION_TYPE\", \"TC_WRITEID\") VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    public List<Object[]> getQueryParameters() {
        return this.dynamicPartitions == null ? this.getQueryParametersByLockRequest() : this.getQueryParametersByDynamicPartitions();
    }

    @Override
    public ParameterizedPreparedStatementSetter<Object[]> getPreparedStatementSetter() {
        return (ps, argument) -> {
            ps.setLong(1, (Long)argument[0]);
            ps.setString(2, (String)argument[1]);
            ps.setString(3, (String)argument[2]);
            ps.setString(4, (String)argument[3]);
            ps.setString(5, (String)argument[4]);
            ps.setObject(6, argument[5], -5);
        };
    }

    @Override
    public Function<Integer, Boolean> resultPolicy() {
        return ParameterizedCommand.EXACTLY_ONE_ROW;
    }

    private List<Object[]> getQueryParametersByLockRequest() {
        assert (this.lockRequest != null);
        ArrayList<Object[]> params = new ArrayList<Object[]>(this.lockRequest.getComponentSize());
        HashSet<Pair> alreadyAddedTables = new HashSet<Pair>();
        for (LockComponent lc : this.lockRequest.getComponent()) {
            if (lc.isSetIsTransactional() && !lc.isIsTransactional() || !this.shouldUpdateTxnComponent(this.lockRequest.getTxnid(), this.lockRequest, lc)) continue;
            Function<LockComponent, Pair> getWriteIdKey = lockComponent -> Pair.of((Object)StringUtils.lowerCase((String)lockComponent.getDbname()), (Object)StringUtils.lowerCase((String)lockComponent.getTablename()));
            String dbName = StringUtils.lowerCase((String)lc.getDbname());
            String tblName = StringUtils.lowerCase((String)lc.getTablename());
            String partName = TxnUtils.normalizePartitionCase(lc.getPartitionname());
            OperationType opType = OperationType.fromDataOperationType(lc.getOperationType());
            Pair writeIdKey = getWriteIdKey.apply(lc);
            Predicate<LockComponent> isDynPart = lockComponent -> lockComponent.isSetIsDynamicPartitionWrite() && lockComponent.isIsDynamicPartitionWrite();
            Set isDynPartUpdate = this.lockRequest.getComponent().stream().filter(isDynPart).filter(lockComponent -> lockComponent.getOperationType() == DataOperationType.UPDATE || lockComponent.getOperationType() == DataOperationType.DELETE).map(getWriteIdKey).collect(Collectors.toSet());
            if (isDynPart.test(lc)) {
                partName = null;
                if (alreadyAddedTables.contains(writeIdKey)) continue;
                opType = isDynPartUpdate.contains(writeIdKey) ? OperationType.UPDATE : OperationType.INSERT;
            }
            Long writeId = this.writeIds.get(writeIdKey);
            params.add(new Object[]{this.lockRequest.getTxnid(), dbName, tblName, partName, opType.getSqlConst(), writeId});
            alreadyAddedTables.add(writeIdKey);
        }
        return params;
    }

    private List<Object[]> getQueryParametersByDynamicPartitions() {
        assert (this.dynamicPartitions != null);
        OperationType ot = OperationType.UPDATE;
        if (this.dynamicPartitions.isSetOperationType()) {
            ot = OperationType.fromDataOperationType(this.dynamicPartitions.getOperationType());
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(this.dynamicPartitions.getPartitionnamesSize());
        for (String partName : this.dynamicPartitions.getPartitionnames()) {
            params.add(new Object[]{this.dynamicPartitions.getTxnid(), this.dynamicPartitions.getDbname().toLowerCase(), this.dynamicPartitions.getTablename().toLowerCase(), partName, ot.getSqlConst(), this.dynamicPartitions.getWriteid()});
        }
        return params;
    }

    private boolean shouldUpdateTxnComponent(long txnid, LockRequest rqst, LockComponent lc) {
        if (!lc.isSetOperationType()) {
            return true;
        }
        switch (lc.getOperationType()) {
            case INSERT: 
            case UPDATE: 
            case DELETE: {
                return true;
            }
            case SELECT: {
                return false;
            }
            case NO_TXN: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected DataOperationType: " + lc.getOperationType() + " agentInfo=" + rqst.getAgentInfo() + " " + JavaUtils.txnIdToString((long)txnid));
    }
}

