/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.tools.schematool.HiveSchemaHelper;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolCommandLine;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTask;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskInit;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskUpgrade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaToolTaskInitOrUpgrade
extends SchemaToolTask {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaToolTaskInitOrUpgrade.class);
    private SchemaToolCommandLine cl;

    @Override
    void setCommandLineArguments(SchemaToolCommandLine cl) {
        this.cl = cl;
    }

    @Override
    void execute() throws HiveMetaException {
        HiveSchemaHelper.MetaStoreConnectionInfo connectionInfo = this.schemaTool.getConnectionInfo(true);
        String dbVersion = null;
        try {
            dbVersion = this.schemaTool.getMetaStoreSchemaInfo().getMetaStoreSchemaVersion(connectionInfo);
        }
        catch (HiveMetaException e) {
            LOG.info("Exception getting db version:" + e.getMessage());
            LOG.info("Try to initialize db schema");
        }
        SchemaToolTask task = dbVersion == null ? new SchemaToolTaskInit() : new SchemaToolTaskUpgrade();
        task.setHiveSchemaTool(this.schemaTool);
        task.setCommandLineArguments(this.cl);
        task.execute();
    }
}

