/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.columnstats.merge;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.TimestampColumnStatsData;
import org.apache.hadoop.hive.metastore.columnstats.cache.DateColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DecimalColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.DoubleColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.LongColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.StringColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.cache.TimestampColumnStatsDataInspector;
import org.apache.hadoop.hive.metastore.columnstats.merge.BinaryColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.BooleanColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.DateColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.DecimalColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.DoubleColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.LongColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.StringColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.TimestampColumnStatsMerger;

public class ColumnStatsMergerFactory {
    private ColumnStatsMergerFactory() {
    }

    public static ColumnStatsMerger<?> getColumnStatsMerger(ColumnStatisticsObj statsObjNew, ColumnStatisticsObj statsObjOld) {
        Objects.requireNonNull(statsObjNew, "Column 1 statistics cannot be null");
        Objects.requireNonNull(statsObjOld, "Column 2 statistics cannot be null");
        ColumnStatisticsData._Fields typeNew = (ColumnStatisticsData._Fields)statsObjNew.getStatsData().getSetField();
        ColumnStatisticsData._Fields typeOld = (ColumnStatisticsData._Fields)statsObjOld.getStatsData().getSetField();
        Preconditions.checkArgument((typeNew == typeOld ? 1 : 0) != 0, (Object)("The column types must match: [" + typeNew + "::" + typeOld + "]"));
        switch (typeNew) {
            case BOOLEAN_STATS: {
                return new BooleanColumnStatsMerger();
            }
            case LONG_STATS: {
                return new LongColumnStatsMerger();
            }
            case DOUBLE_STATS: {
                return new DoubleColumnStatsMerger();
            }
            case STRING_STATS: {
                return new StringColumnStatsMerger();
            }
            case BINARY_STATS: {
                return new BinaryColumnStatsMerger();
            }
            case DECIMAL_STATS: {
                return new DecimalColumnStatsMerger();
            }
            case DATE_STATS: {
                return new DateColumnStatsMerger();
            }
            case TIMESTAMP_STATS: {
                return new TimestampColumnStatsMerger();
            }
        }
        throw new IllegalArgumentException("Unknown stats type: " + statsObjNew.getStatsData().getSetField());
    }

    public static ColumnStatisticsObj newColumnStaticsObj(String colName, String colType, ColumnStatisticsData._Fields type) {
        ColumnStatisticsObj cso = new ColumnStatisticsObj();
        ColumnStatisticsData csd = new ColumnStatisticsData();
        Objects.requireNonNull(colName, "Column name cannot be null");
        Objects.requireNonNull(colType, "Column type cannot be null");
        Objects.requireNonNull(type, "Field type cannot be null");
        switch (type) {
            case BOOLEAN_STATS: {
                csd.setBooleanStats(new BooleanColumnStatsData());
                break;
            }
            case LONG_STATS: {
                csd.setLongStats((LongColumnStatsData)new LongColumnStatsDataInspector());
                break;
            }
            case DOUBLE_STATS: {
                csd.setDoubleStats((DoubleColumnStatsData)new DoubleColumnStatsDataInspector());
                break;
            }
            case STRING_STATS: {
                csd.setStringStats((StringColumnStatsData)new StringColumnStatsDataInspector());
                break;
            }
            case BINARY_STATS: {
                csd.setBinaryStats(new BinaryColumnStatsData());
                break;
            }
            case DECIMAL_STATS: {
                csd.setDecimalStats((DecimalColumnStatsData)new DecimalColumnStatsDataInspector());
                break;
            }
            case DATE_STATS: {
                csd.setDateStats((DateColumnStatsData)new DateColumnStatsDataInspector());
                break;
            }
            case TIMESTAMP_STATS: {
                csd.setTimestampStats((TimestampColumnStatsData)new TimestampColumnStatsDataInspector());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stats type: " + type);
            }
        }
        cso.setColName(colName);
        cso.setColType(colType);
        cso.setStatsData(csd);
        return cso;
    }
}

