/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jdo.Query;
import org.apache.hadoop.hive.metastore.ExceptionHandler;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Batchable<I, R> {
    private static final Logger LOG = LoggerFactory.getLogger(Batchable.class);
    public static final int NO_BATCHING = -1;
    private List<Query> queries = null;

    public abstract List<R> run(List<I> var1) throws Exception;

    public void addQueryAfterUse(Query query) {
        if (this.queries == null) {
            this.queries = new ArrayList<Query>(1);
        }
        this.queries.add(query);
    }

    protected void addQueryAfterUse(Batchable<?, ?> b) {
        if (b.queries == null) {
            return;
        }
        if (this.queries == null) {
            this.queries = new ArrayList<Query>(b.queries);
        } else {
            this.queries.addAll(b.queries);
        }
    }

    public void closeAllQueries() {
        for (Query q : this.queries) {
            try {
                q.closeAll();
            }
            catch (Throwable t) {
                LOG.error("Failed to close a query", t);
            }
        }
    }

    public static <I, R> List<R> runBatched(int batchSize, List<I> input, Batchable<I, R> runnable) throws MetaException {
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            if (batchSize == -1 || batchSize >= input.size()) {
                return runnable.run(input);
            }
            ArrayList<R> result = new ArrayList<R>(input.size());
            int fromIndex = 0;
            int toIndex = 0;
            while (toIndex < input.size()) {
                toIndex = Math.min(fromIndex + batchSize, input.size());
                List<I> batchedInput = input.subList(fromIndex, toIndex);
                List<R> batchedOutput = runnable.run(batchedInput);
                if (batchedOutput != null) {
                    result.addAll(batchedOutput);
                }
                fromIndex = toIndex;
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionHandler.newMetaException(e);
        }
    }
}

