/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapreduce;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.mr.hive.IcebergAcidUtil;
import org.apache.iceberg.mr.mapreduce.AbstractIcebergRecordReader;
import org.apache.iceberg.mr.mapreduce.IcebergMergeSplit;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public final class IcebergMergeRecordReader<T>
extends AbstractIcebergRecordReader<T> {
    private IcebergMergeSplit mergeSplit;
    private CloseableIterator<T> currentIterator;
    private T current;

    @Override
    public void initialize(InputSplit split, TaskAttemptContext newContext) {
        super.initialize(split, newContext);
        this.mergeSplit = (IcebergMergeSplit)split;
        this.currentIterator = this.nextTask();
    }

    private CloseableIterator<T> nextTask() {
        Iterator closeableIterator = this.openGeneric(this.mergeSplit.getContentFile(), this.table.schema()).iterator();
        if (this.mergeSplit.getContentFile() instanceof DeleteFile) {
            Schema deleteSchema = IcebergAcidUtil.createSerdeSchemaForDelete(this.table.schema().columns());
            return new IcebergAcidUtil.MergeTaskVirtualColumnAwareIterator(closeableIterator, deleteSchema, this.conf, this.mergeSplit.getContentFile(), this.table);
        }
        return closeableIterator;
    }

    public boolean nextKeyValue() throws IOException {
        if (this.currentIterator.hasNext()) {
            this.current = this.currentIterator.next();
            return true;
        }
        this.currentIterator.close();
        return false;
    }

    public T getCurrentValue() {
        return this.current;
    }

    public void close() throws IOException {
        this.currentIterator.close();
    }

    private CloseableIterable<T> openGeneric(ContentFile contentFile, Schema readSchema) {
        Schema schema = null;
        if (contentFile instanceof DataFile) {
            schema = readSchema;
        } else if (contentFile instanceof DeleteFile) {
            schema = new Schema(MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS);
        }
        InputFile inputFile = this.table.encryption().decrypt(EncryptedFiles.encryptedInput(this.table.io().newInputFile(contentFile.path().toString()), contentFile.keyMetadata()));
        return switch (contentFile.format()) {
            case FileFormat.AVRO -> this.newAvroIterable(inputFile, schema);
            case FileFormat.ORC -> this.newOrcIterable(inputFile, schema);
            case FileFormat.PARQUET -> this.newParquetIterable(inputFile, schema);
            default -> throw new UnsupportedOperationException(String.format("Cannot read %s file: %s", contentFile.format().name(), contentFile.path()));
        };
    }

    private CloseableIterable<T> newAvroIterable(InputFile inputFile, Schema readSchema) {
        Avro.ReadBuilder avroReadBuilder = Avro.read(inputFile).project(readSchema).split(this.mergeSplit.getStart(), this.mergeSplit.getLength());
        if (this.isReuseContainers()) {
            avroReadBuilder.reuseContainers();
        }
        if (this.getNameMapping() != null) {
            avroReadBuilder.withNameMapping(NameMappingParser.fromJson(this.getNameMapping()));
        }
        avroReadBuilder.createReaderFunc((expIcebergSchema, expAvroSchema) -> DataReader.create(expIcebergSchema, expAvroSchema, Maps.newHashMap()));
        return this.applyResidualFiltering(avroReadBuilder.build(), null, readSchema);
    }

    private CloseableIterable<T> newOrcIterable(InputFile inputFile, Schema readSchema) {
        ORC.ReadBuilder orcReadBuilder = ORC.read(inputFile).project(readSchema).caseSensitive(this.isCaseSensitive()).split(this.mergeSplit.getStart(), this.mergeSplit.getLength());
        if (this.getNameMapping() != null) {
            orcReadBuilder.withNameMapping(NameMappingParser.fromJson(this.getNameMapping()));
        }
        orcReadBuilder.createReaderFunc(fileSchema -> GenericOrcReader.buildReader(readSchema, fileSchema, Maps.newHashMap()));
        return this.applyResidualFiltering(orcReadBuilder.build(), null, readSchema);
    }

    private CloseableIterable<T> newParquetIterable(InputFile inputFile, Schema readSchema) {
        Parquet.ReadBuilder parquetReadBuilder = Parquet.read(inputFile).project(readSchema).caseSensitive(this.isCaseSensitive()).split(this.mergeSplit.getStart(), this.mergeSplit.getLength());
        if (this.isReuseContainers()) {
            parquetReadBuilder.reuseContainers();
        }
        if (this.getNameMapping() != null) {
            parquetReadBuilder.withNameMapping(NameMappingParser.fromJson(this.getNameMapping()));
        }
        parquetReadBuilder.createReaderFunc(fileSchema -> GenericParquetReaders.buildReader(readSchema, fileSchema, Maps.newHashMap()));
        return this.applyResidualFiltering(parquetReadBuilder.build(), null, readSchema);
    }
}

