/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.ClusteredDataWriter;
import org.apache.iceberg.io.ClusteredPositionDeleteWriter;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FanoutDataWriter;
import org.apache.iceberg.io.FanoutPositionOnlyDeleteWriter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.mr.hive.FilesForCommit;
import org.apache.iceberg.mr.hive.writer.HiveFileWriterFactory;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriter;
import org.apache.iceberg.mr.hive.writer.WriterBuilder;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HiveIcebergWriterBase
implements HiveIcebergWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergWriterBase.class);
    protected final FileIO io;
    protected final InternalRecordWrapper wrapper;
    protected final Map<Integer, PartitionSpec> specs;
    protected final Map<Integer, PartitionKey> partitionKeys;
    protected final PartitioningWriter writer;

    HiveIcebergWriterBase(Table table, PartitioningWriter writer) {
        this.io = table.io();
        this.wrapper = new InternalRecordWrapper(table.schema().asStruct());
        this.specs = table.specs();
        this.partitionKeys = Maps.newHashMapWithExpectedSize(this.specs.size());
        this.writer = writer;
    }

    public void close(boolean abort) throws IOException {
        this.writer.close();
        FilesForCommit result = this.files();
        if (abort) {
            Tasks.foreach(result.allFiles()).retry(3).suppressFailureWhenFinished().onFailure((file, exception) -> LOG.debug("Failed on to remove file {} on abort", file, (Object)exception)).run(file -> this.io.deleteFile(file.path().toString()));
            LOG.warn("HiveIcebergWriter is closed with abort");
        }
        LOG.info("Created {} data files and {} delete files", (Object)result.dataFiles().size(), (Object)result.deleteFiles().size());
        LOG.debug(result.toString());
    }

    protected PartitionKey partition(Record row, int specId) {
        PartitionKey partitionKey = this.partitionKeys.computeIfAbsent(specId, id -> new PartitionKey(this.specs.get(id), this.specs.get(id).schema()));
        partitionKey.partition(this.wrapper.wrap(row));
        return partitionKey;
    }

    static PartitioningWriter<Record, DataWriteResult> newDataWriter(Table table, HiveFileWriterFactory writers, OutputFileFactory files, WriterBuilder.Context context) {
        FileIO io = table.io();
        boolean useFanoutWriter = context.useFanoutWriter();
        long targetFileSize = context.targetDataFileSize();
        if (table.spec().isPartitioned() && useFanoutWriter) {
            return new FanoutDataWriter<Record>(writers, files, io, targetFileSize);
        }
        return new ClusteredDataWriter<Record>(writers, files, io, targetFileSize);
    }

    static PartitioningWriter<PositionDelete<Record>, DeleteWriteResult> newDeleteWriter(Table table, HiveFileWriterFactory writers, OutputFileFactory files, WriterBuilder.Context context) {
        FileIO io = table.io();
        boolean inputOrdered = context.inputOrdered();
        long targetFileSize = context.targetDeleteFileSize();
        DeleteGranularity deleteGranularity = context.deleteGranularity();
        if (inputOrdered) {
            return new ClusteredPositionDeleteWriter<Record>(writers, files, io, targetFileSize, deleteGranularity);
        }
        return new FanoutPositionOnlyDeleteWriter<Record>(writers, files, io, targetFileSize, deleteGranularity);
    }
}

