/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kudu;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.kudu.KuduInputFormat;
import org.apache.hadoop.hive.kudu.KuduOutputFormat;
import org.apache.hadoop.hive.kudu.KuduPredicateHandler;
import org.apache.hadoop.hive.kudu.KuduSerDe;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.metadata.StorageHandlerInfo;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveCustomStorageHandlerUtils;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduStorageHandler
extends DefaultStorageHandler
implements HiveStoragePredicateHandler,
HiveStorageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(KuduStorageHandler.class);
    private static final String KUDU_PREFIX = "kudu:";
    private static final String KUDU_PROPERTY_PREFIX = "kudu.";
    public static final String KUDU_TABLE_ID_KEY = "kudu.table_id";
    public static final String KUDU_TABLE_NAME_KEY = "kudu.table_name";
    public static final String KUDU_MASTER_ADDRS_KEY = "kudu.master_addresses";
    public static final List<String> KUDU_TABLE_PROPERTIES = Arrays.asList("kudu.table_id", "kudu.table_name", "kudu.master_addresses");
    private Configuration conf;

    public Class<? extends InputFormat> getInputFormatClass() {
        return KuduInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return KuduOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return KuduSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return null;
    }

    public HiveAuthorizationProvider getAuthorizationProvider() throws HiveException {
        return new DefaultHiveAuthorizationProvider();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureJobProperties(tableDesc, jobProperties);
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureJobProperties(tableDesc, jobProperties);
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureJobProperties(tableDesc, jobProperties);
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        if (UserGroupInformation.isSecurityEnabled()) {
            LOG.debug("Setting {} to {} to enable split generation on HS2", (Object)HiveConf.ConfVars.HIVE_AM_SPLIT_GENERATION.toString(), (Object)Boolean.FALSE.toString());
            jobConf.set(HiveConf.ConfVars.HIVE_AM_SPLIT_GENERATION.toString(), Boolean.FALSE.toString());
        }
        try {
            Utilities.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{KuduStorageHandler.class});
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void configureJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tblProps = tableDesc.getProperties();
        this.copyPropertiesFromTable(jobProperties, tblProps);
    }

    private void copyPropertiesFromTable(Map<String, String> jobProperties, Properties tblProps) {
        for (String propToCopy : KUDU_TABLE_PROPERTIES) {
            if (!tblProps.containsKey(propToCopy)) continue;
            String value = tblProps.getProperty(propToCopy);
            this.conf.set(propToCopy, value);
            jobProperties.put(propToCopy, value);
        }
    }

    public URI getURIForAuth(Table table) throws URISyntaxException {
        Map tableProperties = HiveCustomStorageHandlerUtils.getTableProperties((Table)table);
        String host_name = tableProperties.get(KUDU_MASTER_ADDRS_KEY) != null ? (String)tableProperties.get(KUDU_MASTER_ADDRS_KEY) : this.conf.get(KUDU_MASTER_ADDRS_KEY);
        Preconditions.checkNotNull((Object)host_name, (Object)("Set Table property " + this.conf));
        String table_name = (String)tableProperties.get(KUDU_TABLE_NAME_KEY);
        Preconditions.checkNotNull((Object)table_name, (Object)"Set Table property kudu.table_name");
        return new URI("kudu://" + host_name + "/" + table_name);
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc predicate) {
        Preconditions.checkArgument((boolean)(deserializer instanceof KuduSerDe));
        KuduSerDe serDe = (KuduSerDe)deserializer;
        Schema schema = serDe.getSchema();
        return KuduPredicateHandler.decompose(predicate, schema);
    }

    public StorageHandlerInfo getStorageHandlerInfo(Table table) throws MetaException {
        return null;
    }
}

