/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql.udf;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hive.hplsql.Arguments;
import org.apache.hive.hplsql.Exec;
import org.apache.hive.hplsql.Scope;
import org.apache.hive.hplsql.Var;
import org.apache.hive.hplsql.executor.QueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(name="hplsql", value="_FUNC_('query' [, :1, :2, ...n], 'storedProcedure') - Execute HPL/SQL query", extended="Example:\n > SELECT _FUNC_('CURRENT_DATE') FROM src LIMIT 1;\n")
@UDFType(deterministic=false)
public class Udf
extends GenericUDF {
    private static final Logger LOG = LoggerFactory.getLogger((String)Udf.class.getName());
    public static String NAME = "hplsql";
    private final transient Exec exec = new Exec();
    private StringObjectInspector queryOI;
    private ObjectInspector[] argumentsOI;
    private StringObjectInspector funcDefOI;
    private String functionDefinition = null;

    public Udf() {
        this.exec.setQueryExecutor(QueryExecutor.DISABLED);
        this.exec.init();
    }

    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 2) {
            throw new UDFArgumentLengthException("At least two arguments must be specified");
        }
        if (!(arguments[0] instanceof StringObjectInspector)) {
            throw new UDFArgumentException("First argument must be a string");
        }
        if (!(arguments[arguments.length - 1] instanceof StringObjectInspector)) {
            throw new UDFArgumentException("Last argument (stored procedure) must be a string");
        }
        this.queryOI = (StringObjectInspector)arguments[0];
        this.funcDefOI = (StringObjectInspector)arguments[arguments.length - 1];
        this.argumentsOI = arguments;
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.functionDefinition == null) {
            int idx = arguments.length - 1;
            this.setParameterForPrimitiveTypeArgument(":" + idx, arguments[idx].get(), (ObjectInspector)this.funcDefOI);
            this.functionDefinition = this.funcDefOI.getPrimitiveJavaObject(arguments[idx].get());
            LOG.debug("functionDefinition: {}", (Object)this.functionDefinition);
            this.exec.parseAndEval(Arguments.script(this.functionDefinition));
        }
        this.exec.enterScope(Scope.Type.ROUTINE);
        this.setParameters(arguments);
        String query = this.queryOI.getPrimitiveJavaObject(arguments[0].get());
        try {
            Var result = this.exec.parseAndEval(Arguments.script(query));
            this.exec.callStackPop();
            String string = result != null ? result.toString() : null;
            return string;
        }
        finally {
            this.exec.close();
        }
    }

    public Exec getExec() {
        return this.exec;
    }

    void setParameters(GenericUDF.DeferredObject[] arguments) throws HiveException {
        for (int i = 1; i < arguments.length - 1; ++i) {
            String name = ":" + i;
            Object inputObject = arguments[i].get();
            ObjectInspector objectInspector = this.argumentsOI[i];
            if (objectInspector.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                this.setParameterForPrimitiveTypeArgument(name, inputObject, objectInspector);
                continue;
            }
            this.exec.setVariableToNull(name);
        }
    }

    private void setParameterForPrimitiveTypeArgument(String name, Object inputObject, ObjectInspector objectInspector) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveObjectInspector)objectInspector).getPrimitiveCategory();
        switch (primitiveCategory) {
            case BOOLEAN: {
                Boolean booleanValue = (Boolean)((BooleanObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (booleanValue == null) break;
                this.exec.setVariable(name, new Var(booleanValue));
                break;
            }
            case SHORT: {
                Short shortValue = (Short)((ShortObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (shortValue == null) break;
                this.exec.setVariable(name, new Var(shortValue.longValue()));
                break;
            }
            case INT: {
                Integer intValue = (Integer)((IntObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (intValue == null) break;
                this.exec.setVariable(name, new Var(intValue.longValue()));
                break;
            }
            case LONG: {
                Long longValue = (Long)((LongObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (longValue == null) break;
                this.exec.setVariable(name, new Var(longValue));
                break;
            }
            case FLOAT: {
                Float floatValue = (Float)((FloatObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (floatValue == null) break;
                this.exec.setVariable(name, new Var(floatValue.doubleValue()));
                break;
            }
            case DOUBLE: {
                Double doubleValue = (Double)((DoubleObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (doubleValue == null) break;
                this.exec.setVariable(name, new Var(doubleValue));
                break;
            }
            case STRING: {
                String strValue = ((StringObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (strValue == null) break;
                this.exec.setVariable(name, new Var(strValue));
                break;
            }
            case DATE: {
                org.apache.hadoop.hive.common.type.Date dateValue = ((DateObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (dateValue == null) break;
                this.exec.setVariable(name, new Var(Date.valueOf(dateValue.toString())));
                break;
            }
            case TIMESTAMP: {
                org.apache.hadoop.hive.common.type.Timestamp timestampValue = ((TimestampObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (timestampValue == null) break;
                Timestamp timestamp = Timestamp.valueOf(timestampValue.toString());
                timestamp.setNanos(timestampValue.getNanos());
                this.exec.setVariable(name, new Var(timestamp, 0));
                break;
            }
            case DECIMAL: {
                HiveDecimal decimalValue = ((HiveDecimalObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (decimalValue == null) break;
                this.exec.setVariable(name, new Var(decimalValue.bigDecimalValue()));
                break;
            }
            case VARCHAR: {
                HiveVarchar varcharValue = ((HiveVarcharObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (varcharValue == null) break;
                this.exec.setVariable(name, new Var(varcharValue.getValue()));
                break;
            }
            case CHAR: {
                HiveChar charValue = ((HiveCharObjectInspector)objectInspector).getPrimitiveJavaObject(inputObject);
                if (charValue == null) break;
                this.exec.setVariable(name, new Var(charValue.getStrippedValue()));
                break;
            }
            default: {
                this.exec.setVariableToNull(name);
            }
        }
    }

    public String getDisplayString(String[] children) {
        return "hplsql";
    }
}

