/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.exec.ExecuteException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.BusyException;
import org.apache.hive.hcatalog.templeton.CallbackFailedException;
import org.apache.hive.hcatalog.templeton.ColumnDesc;
import org.apache.hive.hcatalog.templeton.CompleteBean;
import org.apache.hive.hcatalog.templeton.CompleteDelegator;
import org.apache.hive.hcatalog.templeton.DatabaseDesc;
import org.apache.hive.hcatalog.templeton.DeleteDelegator;
import org.apache.hive.hcatalog.templeton.EnqueueBean;
import org.apache.hive.hcatalog.templeton.ExecBean;
import org.apache.hive.hcatalog.templeton.ExecService;
import org.apache.hive.hcatalog.templeton.ExecServiceImpl;
import org.apache.hive.hcatalog.templeton.HcatDelegator;
import org.apache.hive.hcatalog.templeton.HcatException;
import org.apache.hive.hcatalog.templeton.HiveDelegator;
import org.apache.hive.hcatalog.templeton.JarDelegator;
import org.apache.hive.hcatalog.templeton.JobItemBean;
import org.apache.hive.hcatalog.templeton.LauncherDelegator;
import org.apache.hive.hcatalog.templeton.ListDelegator;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.PartitionDesc;
import org.apache.hive.hcatalog.templeton.PigDelegator;
import org.apache.hive.hcatalog.templeton.ProxyUserSupport;
import org.apache.hive.hcatalog.templeton.QueueException;
import org.apache.hive.hcatalog.templeton.QueueStatusBean;
import org.apache.hive.hcatalog.templeton.SimpleWebException;
import org.apache.hive.hcatalog.templeton.SqoopDelegator;
import org.apache.hive.hcatalog.templeton.StatusDelegator;
import org.apache.hive.hcatalog.templeton.StreamingDelegator;
import org.apache.hive.hcatalog.templeton.TableDesc;
import org.apache.hive.hcatalog.templeton.TableLikeDesc;
import org.apache.hive.hcatalog.templeton.TablePropertyDesc;
import org.apache.hive.hcatalog.templeton.TooManyRequestsException;
import org.apache.hive.hcatalog.templeton.VersionDelegator;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1")
public class Server {
    public static final String VERSION = "v1";
    public static final String DO_AS_PARAM = "doAs";
    public static final Map<String, String> STATUS_OK = Server.createStatusMsg();
    public static final Map<String, Object> SUPPORTED_VERSIONS = Server.createVersions();
    public static final Map<String, Object> SUPPORTED_FORMATS = Server.createFormats();
    protected static ExecService execService = ExecServiceImpl.getInstance();
    private static AppConfig appConf = Main.getAppConfigInstance();
    @Context
    private SecurityContext theSecurityContext;
    @Context
    private UriInfo theUriInfo;
    @QueryParam(value="doAs")
    private String doAs;
    @Context
    private HttpServletRequest request;
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    public static final Pattern DDL_ID = Pattern.compile("[a-zA-Z]\\w*");
    public static final Pattern PROPERTY_ID = Pattern.compile("[a-zA-Z0-9][\\w\\.\\-]*(?<!\\-)(?<!\\.)(?<!\\_)$");

    private static Map<String, String> createStatusMsg() {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("status", "ok");
        res.put("version", VERSION);
        return Collections.unmodifiableMap(res);
    }

    private static Map<String, Object> createVersions() {
        ArrayList<String> versions = new ArrayList<String>();
        versions.add(VERSION);
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("supportedVersions", versions);
        res.put("version", VERSION);
        return Collections.unmodifiableMap(res);
    }

    private static Map<String, Object> createFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("application/json");
        HashMap<String, ArrayList<String>> res = new HashMap<String, ArrayList<String>>();
        res.put("responseTypes", formats);
        return Collections.unmodifiableMap(res);
    }

    @GET
    @Path(value="status")
    @Produces(value={"application/json"})
    public Map<String, String> status() {
        return STATUS_OK;
    }

    @GET
    @Produces(value={"application/json"})
    public Map<String, Object> requestFormats() {
        return SUPPORTED_FORMATS;
    }

    @GET
    @Path(value="version")
    @Produces(value={"application/json"})
    public Map<String, Object> version() {
        return SUPPORTED_VERSIONS;
    }

    @GET
    @Path(value="version/hadoop")
    @Produces(value={"application/json"})
    public Response hadoopVersion() throws IOException {
        VersionDelegator d = new VersionDelegator(appConf);
        return d.getVersion("hadoop");
    }

    @GET
    @Path(value="version/hive")
    @Produces(value={"application/json"})
    public Response hiveVersion() throws IOException {
        VersionDelegator d = new VersionDelegator(appConf);
        return d.getVersion("hive");
    }

    @GET
    @Path(value="version/sqoop")
    @Produces(value={"application/json"})
    public Response sqoopVersion() throws IOException {
        VersionDelegator d = new VersionDelegator(appConf);
        return d.getVersion("sqoop");
    }

    @GET
    @Path(value="version/pig")
    @Produces(value={"application/json"})
    public Response pigVersion() throws IOException {
        VersionDelegator d = new VersionDelegator(appConf);
        return d.getVersion("pig");
    }

    @POST
    @Path(value="ddl")
    @Produces(value={"application/json"})
    public ExecBean ddl(@FormParam(value="exec") String exec, @FormParam(value="group") String group, @FormParam(value="permissions") String permissions) throws NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyParam(exec, "exec");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.run(this.getDoAsUser(), exec, false, group, permissions);
    }

    @GET
    @Path(value="ddl/database/{db}/table")
    @Produces(value={"application/json"})
    public Response listTables(@PathParam(value="db") String db, @QueryParam(value="like") String tablePattern) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        if (!TempletonUtils.isset(tablePattern)) {
            tablePattern = "*";
        }
        return d.listTables(this.getDoAsUser(), db, tablePattern);
    }

    @PUT
    @Path(value="ddl/database/{db}/table/{table}")
    @Produces(value={"application/json"})
    public Response createTable(@PathParam(value="db") String db, @PathParam(value="table") String table, TableDesc desc) throws SimpleWebException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        desc.table = table;
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.createTable(this.getDoAsUser(), db, desc);
    }

    @PUT
    @Path(value="ddl/database/{db}/table/{existingTable}/like/{newTable}")
    @Produces(value={"application/json"})
    public Response createTableLike(@PathParam(value="db") String db, @PathParam(value="existingTable") String existingTable, @PathParam(value="newTable") String newTable, TableLikeDesc desc) throws SimpleWebException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(existingTable, ":existingTable");
        this.verifyDdlParam(newTable, ":newTable");
        desc.existingTable = existingTable;
        desc.newTable = newTable;
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.createTableLike(this.getDoAsUser(), db, desc);
    }

    @GET
    @Path(value="ddl/database/{db}/table/{table}")
    @Produces(value={"application/json"})
    public Response descTable(@PathParam(value="db") String db, @PathParam(value="table") String table, @QueryParam(value="format") String format) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        if ("extended".equals(format)) {
            return d.descExtendedTable(this.getDoAsUser(), db, table);
        }
        return d.descTable(this.getDoAsUser(), db, table, false);
    }

    @DELETE
    @Path(value="ddl/database/{db}/table/{table}")
    @Produces(value={"application/json"})
    public Response dropTable(@PathParam(value="db") String db, @PathParam(value="table") String table, @QueryParam(value="ifExists") boolean ifExists, @QueryParam(value="group") String group, @QueryParam(value="permissions") String permissions) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.dropTable(this.getDoAsUser(), db, table, ifExists, group, permissions);
    }

    @POST
    @Path(value="ddl/database/{db}/table/{table}")
    @Produces(value={"application/json"})
    public Response renameTable(@PathParam(value="db") String db, @PathParam(value="table") String oldTable, @FormParam(value="rename") String newTable, @FormParam(value="group") String group, @FormParam(value="permissions") String permissions) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(oldTable, ":table");
        this.verifyDdlParam(newTable, "rename");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.renameTable(this.getDoAsUser(), db, oldTable, newTable, group, permissions);
    }

    @GET
    @Path(value="ddl/database/{db}/table/{table}/property/{property}")
    @Produces(value={"application/json"})
    public Response descOneTableProperty(@PathParam(value="db") String db, @PathParam(value="table") String table, @PathParam(value="property") String property) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        this.verifyPropertyParam(property, ":property");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.descTableProperty(this.getDoAsUser(), db, table, property);
    }

    @GET
    @Path(value="ddl/database/{db}/table/{table}/property")
    @Produces(value={"application/json"})
    public Response listTableProperties(@PathParam(value="db") String db, @PathParam(value="table") String table) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.listTableProperties(this.getDoAsUser(), db, table);
    }

    @PUT
    @Path(value="ddl/database/{db}/table/{table}/property/{property}")
    @Produces(value={"application/json"})
    public Response addOneTableProperty(@PathParam(value="db") String db, @PathParam(value="table") String table, @PathParam(value="property") String property, TablePropertyDesc desc) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        this.verifyPropertyParam(property, ":property");
        desc.name = property;
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.addOneTableProperty(this.getDoAsUser(), db, table, desc);
    }

    @GET
    @Path(value="ddl/database/{db}/table/{table}/partition")
    @Produces(value={"application/json"})
    public Response listPartitions(@PathParam(value="db") String db, @PathParam(value="table") String table) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.listPartitions(this.getDoAsUser(), db, table);
    }

    @GET
    @Path(value="ddl/database/{db}/table/{table}/partition/{partition}")
    @Produces(value={"application/json"})
    public Response descPartition(@PathParam(value="db") String db, @PathParam(value="table") String table, @PathParam(value="partition") String partition) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        this.verifyParam(partition, ":partition");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.descOnePartition(this.getDoAsUser(), db, table, partition);
    }

    @PUT
    @Path(value="ddl/database/{db}/table/{table}/partition/{partition}")
    @Produces(value={"application/json"})
    public Response addOnePartition(@PathParam(value="db") String db, @PathParam(value="table") String table, @PathParam(value="partition") String partition, PartitionDesc desc) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        this.verifyParam(partition, ":partition");
        desc.partition = partition;
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.addOnePartition(this.getDoAsUser(), db, table, desc);
    }

    @DELETE
    @Path(value="ddl/database/{db}/table/{table}/partition/{partition}")
    @Produces(value={"application/json"})
    public Response dropPartition(@PathParam(value="db") String db, @PathParam(value="table") String table, @PathParam(value="partition") String partition, @QueryParam(value="ifExists") boolean ifExists, @QueryParam(value="group") String group, @QueryParam(value="permissions") String permissions) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        this.verifyParam(partition, ":partition");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.dropPartition(this.getDoAsUser(), db, table, partition, ifExists, group, permissions);
    }

    @GET
    @Path(value="ddl/database/")
    @Produces(value={"application/json"})
    public Response listDatabases(@QueryParam(value="like") String dbPattern) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        HcatDelegator d = new HcatDelegator(appConf, execService);
        if (!TempletonUtils.isset(dbPattern)) {
            dbPattern = "*";
        }
        return d.listDatabases(this.getDoAsUser(), dbPattern);
    }

    @GET
    @Path(value="ddl/database/{db}")
    @Produces(value={"application/json"})
    public Response descDatabase(@PathParam(value="db") String db, @QueryParam(value="format") String format) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.descDatabase(this.getDoAsUser(), db, "extended".equals(format));
    }

    @PUT
    @Path(value="ddl/database/{db}")
    @Produces(value={"application/json"})
    public Response createDatabase(@PathParam(value="db") String db, DatabaseDesc desc) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        desc.database = db;
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.createDatabase(this.getDoAsUser(), desc);
    }

    @DELETE
    @Path(value="ddl/database/{db}")
    @Produces(value={"application/json"})
    public Response dropDatabase(@PathParam(value="db") String db, @QueryParam(value="ifExists") boolean ifExists, @QueryParam(value="option") String option, @QueryParam(value="group") String group, @QueryParam(value="permissions") String permissions) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        if (TempletonUtils.isset(option)) {
            this.verifyDdlParam(option, "option");
        }
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.dropDatabase(this.getDoAsUser(), db, ifExists, option, group, permissions);
    }

    @GET
    @Path(value="ddl/database/{db}/table/{table}/column")
    @Produces(value={"application/json"})
    public Response listColumns(@PathParam(value="db") String db, @PathParam(value="table") String table) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.listColumns(this.getDoAsUser(), db, table);
    }

    @GET
    @Path(value="ddl/database/{db}/table/{table}/column/{column}")
    @Produces(value={"application/json"})
    public Response descColumn(@PathParam(value="db") String db, @PathParam(value="table") String table, @PathParam(value="column") String column) throws SimpleWebException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        this.verifyParam(column, ":column");
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.descOneColumn(this.getDoAsUser(), db, table, column);
    }

    @PUT
    @Path(value="ddl/database/{db}/table/{table}/column/{column}")
    @Produces(value={"application/json"})
    public Response addOneColumn(@PathParam(value="db") String db, @PathParam(value="table") String table, @PathParam(value="column") String column, ColumnDesc desc) throws HcatException, NotAuthorizedException, BusyException, BadParam, ExecuteException, IOException {
        this.verifyUser();
        this.verifyDdlParam(db, ":db");
        this.verifyDdlParam(table, ":table");
        this.verifyParam(column, ":column");
        this.verifyParam(desc.type, "type");
        desc.name = column;
        HcatDelegator d = new HcatDelegator(appConf, execService);
        return d.addOneColumn(this.getDoAsUser(), db, table, desc);
    }

    @POST
    @Path(value="mapreduce/streaming")
    @Produces(value={"application/json"})
    public EnqueueBean mapReduceStreaming(@FormParam(value="input") List<String> inputs, @FormParam(value="inputreader") String inputreader, @FormParam(value="output") String output, @FormParam(value="mapper") String mapper, @FormParam(value="reducer") String reducer, @FormParam(value="combiner") String combiner, @FormParam(value="file") List<String> fileList, @FormParam(value="files") String files, @FormParam(value="define") List<String> defines, @FormParam(value="cmdenv") List<String> cmdenvs, @FormParam(value="arg") List<String> args, @FormParam(value="statusdir") String statusdir, @FormParam(value="callback") String callback, @FormParam(value="enablelog") boolean enablelog, @FormParam(value="enablejobreconnect") Boolean enablejobreconnect) throws NotAuthorizedException, BusyException, BadParam, QueueException, ExecuteException, IOException, InterruptedException, TooManyRequestsException {
        this.verifyUser();
        this.verifyParam(inputs, "input");
        this.verifyParam(mapper, "mapper");
        this.verifyParam(reducer, "reducer");
        HashMap<String, Object> userArgs = new HashMap<String, Object>();
        userArgs.put("user.name", this.getDoAsUser());
        userArgs.put("input", inputs);
        userArgs.put("inputreader", inputreader);
        userArgs.put("output", output);
        userArgs.put("mapper", mapper);
        userArgs.put("reducer", reducer);
        userArgs.put("combiner", combiner);
        userArgs.put("file", fileList);
        userArgs.put("files", files);
        userArgs.put("define", defines);
        userArgs.put("cmdenv", cmdenvs);
        userArgs.put("arg", args);
        userArgs.put("statusdir", statusdir);
        userArgs.put("callback", callback);
        userArgs.put("enablelog", Boolean.toString(enablelog));
        userArgs.put("enablejobreconnect", enablejobreconnect);
        this.checkEnableLogPrerequisite(enablelog, statusdir);
        StreamingDelegator d = new StreamingDelegator(appConf);
        return d.run(this.getDoAsUser(), userArgs, inputs, inputreader, output, mapper, reducer, combiner, fileList, files, defines, cmdenvs, args, statusdir, callback, this.getCompletedUrl(), enablelog, enablejobreconnect, LauncherDelegator.JobType.STREAMING);
    }

    @POST
    @Path(value="mapreduce/jar")
    @Produces(value={"application/json"})
    public EnqueueBean mapReduceJar(@FormParam(value="jar") String jar, @FormParam(value="class") String mainClass, @FormParam(value="libjars") String libjars, @FormParam(value="files") String files, @FormParam(value="arg") List<String> args, @FormParam(value="define") List<String> defines, @FormParam(value="statusdir") String statusdir, @FormParam(value="callback") String callback, @FormParam(value="usehcatalog") boolean usesHcatalog, @FormParam(value="enablelog") boolean enablelog, @FormParam(value="enablejobreconnect") Boolean enablejobreconnect) throws NotAuthorizedException, BusyException, BadParam, QueueException, ExecuteException, IOException, InterruptedException, TooManyRequestsException {
        this.verifyUser();
        this.verifyParam(jar, "jar");
        this.verifyParam(mainClass, "class");
        HashMap<String, Object> userArgs = new HashMap<String, Object>();
        userArgs.put("user.name", this.getDoAsUser());
        userArgs.put("jar", jar);
        userArgs.put("class", mainClass);
        userArgs.put("libjars", libjars);
        userArgs.put("files", files);
        userArgs.put("arg", args);
        userArgs.put("define", defines);
        userArgs.put("statusdir", statusdir);
        userArgs.put("callback", callback);
        userArgs.put("enablelog", Boolean.toString(enablelog));
        userArgs.put("enablejobreconnect", enablejobreconnect);
        this.checkEnableLogPrerequisite(enablelog, statusdir);
        JarDelegator d = new JarDelegator(appConf);
        return d.run(this.getDoAsUser(), userArgs, jar, mainClass, libjars, files, args, defines, statusdir, callback, usesHcatalog, this.getCompletedUrl(), enablelog, enablejobreconnect, LauncherDelegator.JobType.JAR);
    }

    @POST
    @Path(value="pig")
    @Produces(value={"application/json"})
    public EnqueueBean pig(@FormParam(value="execute") String execute, @FormParam(value="file") String srcFile, @FormParam(value="arg") List<String> pigArgs, @FormParam(value="files") String otherFiles, @FormParam(value="statusdir") String statusdir, @FormParam(value="callback") String callback, @FormParam(value="usehcatalog") boolean usesHcatalog, @FormParam(value="enablelog") boolean enablelog, @FormParam(value="enablejobreconnect") Boolean enablejobreconnect) throws NotAuthorizedException, BusyException, BadParam, QueueException, ExecuteException, IOException, InterruptedException, TooManyRequestsException {
        this.verifyUser();
        if (execute == null && srcFile == null) {
            throw new BadParam("Either execute or file parameter required");
        }
        HashMap<String, Object> userArgs = new HashMap<String, Object>();
        userArgs.put("user.name", this.getDoAsUser());
        userArgs.put("execute", execute);
        userArgs.put("file", srcFile);
        userArgs.put("arg", pigArgs);
        userArgs.put("files", otherFiles);
        userArgs.put("statusdir", statusdir);
        userArgs.put("callback", callback);
        userArgs.put("enablelog", Boolean.toString(enablelog));
        userArgs.put("enablejobreconnect", enablejobreconnect);
        this.checkEnableLogPrerequisite(enablelog, statusdir);
        PigDelegator d = new PigDelegator(appConf);
        return d.run(this.getDoAsUser(), userArgs, execute, srcFile, pigArgs, otherFiles, statusdir, callback, usesHcatalog, this.getCompletedUrl(), enablelog, enablejobreconnect);
    }

    @POST
    @Path(value="sqoop")
    @Produces(value={"application/json"})
    public EnqueueBean sqoop(@FormParam(value="command") String command, @FormParam(value="optionsfile") String optionsFile, @FormParam(value="libdir") String libdir, @FormParam(value="files") String otherFiles, @FormParam(value="statusdir") String statusdir, @FormParam(value="callback") String callback, @FormParam(value="enablelog") boolean enablelog, @FormParam(value="enablejobreconnect") Boolean enablejobreconnect) throws NotAuthorizedException, BusyException, BadParam, QueueException, IOException, InterruptedException, TooManyRequestsException {
        this.verifyUser();
        if (command == null && optionsFile == null) {
            throw new BadParam("Must define Sqoop command or a optionsfile contains Sqoop command to run Sqoop job.");
        }
        if (command != null && optionsFile != null) {
            throw new BadParam("Cannot set command and optionsfile at the same time.");
        }
        this.checkEnableLogPrerequisite(enablelog, statusdir);
        HashMap<String, Object> userArgs = new HashMap<String, Object>();
        userArgs.put("user.name", this.getDoAsUser());
        userArgs.put("command", command);
        userArgs.put("optionsfile", optionsFile);
        userArgs.put("libdir", libdir);
        userArgs.put("files", otherFiles);
        userArgs.put("statusdir", statusdir);
        userArgs.put("callback", callback);
        userArgs.put("enablelog", Boolean.toString(enablelog));
        userArgs.put("enablejobreconnect", enablejobreconnect);
        SqoopDelegator d = new SqoopDelegator(appConf);
        return d.run(this.getDoAsUser(), userArgs, command, optionsFile, otherFiles, statusdir, callback, this.getCompletedUrl(), enablelog, enablejobreconnect, libdir);
    }

    @POST
    @Path(value="hive")
    @Produces(value={"application/json"})
    public EnqueueBean hive(@FormParam(value="execute") String execute, @FormParam(value="file") String srcFile, @FormParam(value="arg") List<String> hiveArgs, @FormParam(value="files") String otherFiles, @FormParam(value="define") List<String> defines, @FormParam(value="statusdir") String statusdir, @FormParam(value="callback") String callback, @FormParam(value="enablelog") boolean enablelog, @FormParam(value="enablejobreconnect") Boolean enablejobreconnect) throws NotAuthorizedException, BusyException, BadParam, QueueException, ExecuteException, IOException, InterruptedException, TooManyRequestsException {
        this.verifyUser();
        if (execute == null && srcFile == null) {
            throw new BadParam("Either execute or file parameter required");
        }
        HashMap<String, Object> userArgs = new HashMap<String, Object>();
        userArgs.put("user.name", this.getDoAsUser());
        userArgs.put("execute", execute);
        userArgs.put("file", srcFile);
        userArgs.put("define", defines);
        userArgs.put("files", otherFiles);
        userArgs.put("statusdir", statusdir);
        userArgs.put("callback", callback);
        userArgs.put("enablelog", Boolean.toString(enablelog));
        userArgs.put("enablejobreconnect", enablejobreconnect);
        this.checkEnableLogPrerequisite(enablelog, statusdir);
        HiveDelegator d = new HiveDelegator(appConf);
        return d.run(this.getDoAsUser(), userArgs, execute, srcFile, defines, hiveArgs, otherFiles, statusdir, callback, this.getCompletedUrl(), enablelog, enablejobreconnect);
    }

    @GET
    @Path(value="jobs/{jobid}")
    @Produces(value={"application/json"})
    public QueueStatusBean showJobId(@PathParam(value="jobid") String jobid) throws NotAuthorizedException, BadParam, IOException, InterruptedException, BusyException, TimeoutException, ExecutionException, TooManyRequestsException {
        this.verifyUser();
        this.verifyParam(jobid, ":jobid");
        StatusDelegator d = new StatusDelegator(appConf);
        return d.run(this.getDoAsUser(), jobid);
    }

    @DELETE
    @Path(value="jobs/{jobid}")
    @Produces(value={"application/json"})
    public QueueStatusBean deleteJobId(@PathParam(value="jobid") String jobid) throws NotAuthorizedException, BadParam, IOException, InterruptedException {
        this.verifyUser();
        this.verifyParam(jobid, ":jobid");
        DeleteDelegator d = new DeleteDelegator(appConf);
        return d.run(this.getDoAsUser(), jobid);
    }

    @GET
    @Path(value="jobs")
    @Produces(value={"application/json"})
    public List<JobItemBean> showJobList(@QueryParam(value="fields") String fields, @QueryParam(value="showall") boolean showall, @QueryParam(value="jobid") String jobid, @QueryParam(value="numrecords") String numrecords) throws NotAuthorizedException, BadParam, IOException, InterruptedException, BusyException, TimeoutException, ExecutionException, TooManyRequestsException {
        int numRecords;
        this.verifyUser();
        boolean showDetails = false;
        if (fields != null && !fields.equals("*")) {
            throw new BadParam("fields value other than * is not supported");
        }
        if (fields != null && fields.equals("*")) {
            showDetails = true;
        }
        try {
            if (numrecords != null) {
                numRecords = Integer.parseInt(numrecords);
                if (numRecords <= 0) {
                    throw new BadParam("numrecords should be an integer > 0");
                }
            } else {
                numRecords = -1;
            }
        }
        catch (Exception e) {
            throw new BadParam("Invalid numrecords format: numrecords should be an integer > 0");
        }
        ListDelegator ld = new ListDelegator(appConf);
        return ld.run(this.getDoAsUser(), showall, jobid, numRecords, showDetails);
    }

    @GET
    @Path(value="internal/complete/{jobid}")
    @Produces(value={"application/json"})
    public CompleteBean completeJob(@PathParam(value="jobid") String jobid, @QueryParam(value="status") String jobStatus) throws CallbackFailedException, IOException {
        LOG.debug("Received callback " + this.theUriInfo.getRequestUri());
        CompleteDelegator d = new CompleteDelegator(appConf);
        return d.run(jobid, jobStatus);
    }

    public void verifyUser() throws NotAuthorizedException {
        String requestingUser = this.getRequestingUser();
        if (requestingUser == null) {
            Object msg = "No user found.";
            if (!UserGroupInformation.isSecurityEnabled()) {
                msg = (String)msg + "  Missing user.name parameter.";
            }
            throw new NotAuthorizedException((String)msg);
        }
        if (this.doAs != null && !this.doAs.equals(requestingUser)) {
            ProxyUserSupport.validate(requestingUser, Server.getRequestingHost(requestingUser, this.request), this.doAs);
        }
    }

    private String getDoAsUser() {
        return this.doAs != null && !this.doAs.equals(this.getRequestingUser()) ? this.doAs : this.getRequestingUser();
    }

    public void verifyParam(String param, String name) throws BadParam {
        if (param == null) {
            throw new BadParam("Missing " + name + " parameter");
        }
    }

    public void verifyParam(List<String> param, String name) throws BadParam {
        if (param == null || param.isEmpty()) {
            throw new BadParam("Missing " + name + " parameter");
        }
    }

    public void verifyDdlParam(String param, String name) throws BadParam {
        this.verifyParam(param, name);
        Matcher m = DDL_ID.matcher(param);
        if (!m.matches()) {
            throw new BadParam("Invalid DDL identifier " + name);
        }
    }

    public void verifyPropertyParam(String param, String name) throws BadParam {
        this.verifyParam(param, name);
        Matcher m = PROPERTY_ID.matcher(param);
        if (!m.matches()) {
            throw new BadParam("Invalid property name " + name);
        }
    }

    private String getRequestingUser() {
        if (this.theSecurityContext == null) {
            return null;
        }
        String userName = null;
        userName = this.theSecurityContext.getUserPrincipal() == null ? Main.UserNameHandler.getUserName(this.request) : this.theSecurityContext.getUserPrincipal().getName();
        if (userName == null) {
            return null;
        }
        return UserGroupInformation.createRemoteUser((String)userName).getShortUserName();
    }

    public String getCompletedUrl() {
        if (this.theUriInfo == null) {
            return null;
        }
        if (this.theUriInfo.getBaseUri() == null) {
            return null;
        }
        return this.theUriInfo.getBaseUri() + "v1/internal/complete/$jobId?status=$jobStatus";
    }

    private static String getRequestingHost(String requestingUser, HttpServletRequest request) {
        String unkHost = "???";
        if (request == null) {
            LOG.warn("request is null; cannot determine hostname");
            return "???";
        }
        try {
            String address = request.getRemoteAddr();
            if (address == null) {
                LOG.warn(MessageFormat.format("Request remote address is NULL for user [{0}]", requestingUser));
                return "???";
            }
            String hostName = InetAddress.getByName(address).getCanonicalHostName();
            if (LOG.isDebugEnabled()) {
                LOG.debug(MessageFormat.format("Resolved remote hostname: [{0}]", hostName));
            }
            return hostName;
        }
        catch (UnknownHostException ex) {
            LOG.warn(MessageFormat.format("Request remote address could not be resolved, {0}", ex.toString(), ex));
            return "???";
        }
    }

    private void checkEnableLogPrerequisite(boolean enablelog, String statusdir) throws BadParam {
        if (enablelog && !TempletonUtils.isset(statusdir)) {
            throw new BadParam("enablelog is only applicable when statusdir is set");
        }
        if (enablelog && "0.23".equalsIgnoreCase(ShimLoader.getMajorVersion())) {
            throw new BadParam("enablelog=true is only supported with Hadoop 1.x");
        }
    }
}

