/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kudu.shaded.io.micrometer.core.instrument.AbstractMeter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Clock;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Meter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Timer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.Histogram;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.HistogramSnapshot;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.NoopHistogram;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.TimeWindowPercentileHistogram;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.pause.ClockDriftPauseDetector;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import org.apache.kudu.shaded.io.micrometer.core.instrument.util.MeterEquivalence;
import org.apache.kudu.shaded.io.micrometer.core.lang.Nullable;
import org.apache.kudu.shaded.org.LatencyUtils.IntervalEstimator;
import org.apache.kudu.shaded.org.LatencyUtils.SimplePauseDetector;
import org.apache.kudu.shaded.org.LatencyUtils.TimeCappedMovingAverageIntervalEstimator;

public abstract class AbstractTimer
extends AbstractMeter
implements Timer {
    private static Map<PauseDetector, org.apache.kudu.shaded.org.LatencyUtils.PauseDetector> pauseDetectorCache = new ConcurrentHashMap<PauseDetector, org.apache.kudu.shaded.org.LatencyUtils.PauseDetector>();
    protected final Clock clock;
    protected final Histogram histogram;
    private final TimeUnit baseTimeUnit;
    @Nullable
    private IntervalEstimator intervalEstimator = null;
    @Nullable
    private org.apache.kudu.shaded.org.LatencyUtils.PauseDetector pauseDetector;

    @Deprecated
    protected AbstractTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit) {
        this(id, clock, distributionStatisticConfig, pauseDetector, baseTimeUnit, false);
    }

    protected AbstractTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit baseTimeUnit, boolean supportsAggregablePercentiles) {
        super(id);
        this.clock = clock;
        this.baseTimeUnit = baseTimeUnit;
        this.initPauseDetector(pauseDetector);
        this.histogram = distributionStatisticConfig.isPublishingPercentiles() ? new TimeWindowPercentileHistogram(clock, distributionStatisticConfig, supportsAggregablePercentiles) : (distributionStatisticConfig.isPublishingHistogram() ? new TimeWindowFixedBoundaryHistogram(clock, distributionStatisticConfig, supportsAggregablePercentiles) : NoopHistogram.INSTANCE);
    }

    private void initPauseDetector(PauseDetector pauseDetectorType) {
        this.pauseDetector = pauseDetectorCache.computeIfAbsent(pauseDetectorType, detector -> {
            if (detector instanceof ClockDriftPauseDetector) {
                ClockDriftPauseDetector clockDriftPauseDetector = (ClockDriftPauseDetector)detector;
                return new SimplePauseDetector(clockDriftPauseDetector.getSleepInterval().toNanos(), clockDriftPauseDetector.getPauseThreshold().toNanos(), 1, false);
            }
            return null;
        });
        if (this.pauseDetector instanceof SimplePauseDetector) {
            this.intervalEstimator = new TimeCappedMovingAverageIntervalEstimator(128, 10000000000L, this.pauseDetector);
            this.pauseDetector.addListener((pauseLength, pauseEndTime) -> {
                long estimatedInterval;
                long observedLatencyMinbar;
                if (this.intervalEstimator != null && (observedLatencyMinbar = pauseLength - (estimatedInterval = this.intervalEstimator.getEstimatedInterval(pauseEndTime))) >= estimatedInterval) {
                    this.recordValueWithExpectedInterval(observedLatencyMinbar, estimatedInterval);
                }
            });
        }
    }

    private void recordValueWithExpectedInterval(long nanoValue, long expectedIntervalBetweenValueSamples) {
        this.record(nanoValue, TimeUnit.NANOSECONDS);
        if (expectedIntervalBetweenValueSamples <= 0L) {
            return;
        }
        for (long missingValue = nanoValue - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
            this.record(missingValue, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T recordCallable(Callable<T> f) throws Exception {
        long s2 = this.clock.monotonicTime();
        try {
            T t2 = f.call();
            return t2;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T record(Supplier<T> f) {
        long s2 = this.clock.monotonicTime();
        try {
            T t2 = f.get();
            return t2;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s2, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(Runnable f) {
        long s2 = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s2, TimeUnit.NANOSECONDS);
        }
    }

    @Override
    public final void record(long amount, TimeUnit unit) {
        if (amount >= 0L) {
            this.histogram.recordLong(TimeUnit.NANOSECONDS.convert(amount, unit));
            this.recordNonNegative(amount, unit);
            if (this.intervalEstimator != null) {
                this.intervalEstimator.recordInterval(this.clock.monotonicTime());
            }
        }
    }

    protected abstract void recordNonNegative(long var1, TimeUnit var3);

    @Override
    public HistogramSnapshot takeSnapshot() {
        return this.histogram.takeSnapshot(this.count(), this.totalTime(TimeUnit.NANOSECONDS), this.max(TimeUnit.NANOSECONDS));
    }

    @Override
    public TimeUnit baseTimeUnit() {
        return this.baseTimeUnit;
    }

    public boolean equals(@Nullable Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }

    @Override
    public void close() {
        this.histogram.close();
        if (this.pauseDetector != null) {
            this.pauseDetector.shutdown();
        }
    }
}

