/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.InputStream;
import java.util.Objects;
import java.util.function.Function;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.parquet.hadoop.util.H1SeekableInputStream;
import org.apache.parquet.hadoop.util.H2SeekableInputStream;
import org.apache.parquet.hadoop.util.HadoopPositionOutputStream;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.util.DynMethods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStreams {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopStreams.class);
    private static final DynMethods.UnboundMethod hasCapabilitiesMethod = new DynMethods.Builder("hasCapabilities").impl(FSDataInputStream.class, "hasCapabilities", String.class).orNoop().build();

    public static SeekableInputStream wrap(FSDataInputStream stream) {
        Objects.requireNonNull(stream, "Cannot wrap a null input stream");
        Boolean hasCapabilitiesResult = HadoopStreams.isWrappedStreamByteBufferReadable(stream);
        if (hasCapabilitiesResult != null) {
            if (hasCapabilitiesResult.booleanValue()) {
                return new H2SeekableInputStream(stream);
            }
            return new H1SeekableInputStream(stream);
        }
        return HadoopStreams.unwrapByteBufferReadableLegacy(stream).apply(stream);
    }

    private static Function<FSDataInputStream, SeekableInputStream> unwrapByteBufferReadableLegacy(FSDataInputStream stream) {
        InputStream wrapped = stream.getWrappedStream();
        if (wrapped instanceof FSDataInputStream) {
            LOG.debug("Checking on wrapped stream {} of {} whether is ByteBufferReadable", (Object)wrapped, (Object)stream);
            return HadoopStreams.unwrapByteBufferReadableLegacy((FSDataInputStream)wrapped);
        }
        if (stream.getWrappedStream() instanceof ByteBufferReadable) {
            return H2SeekableInputStream::new;
        }
        return H1SeekableInputStream::new;
    }

    private static Boolean isWrappedStreamByteBufferReadable(FSDataInputStream stream) {
        if (hasCapabilitiesMethod.isNoop()) {
            return null;
        }
        boolean isByteBufferReadable = (Boolean)hasCapabilitiesMethod.invoke(stream, "in:readbytebuffer");
        if (isByteBufferReadable) {
            return true;
        }
        InputStream wrapped = stream.getWrappedStream();
        if (wrapped instanceof FSDataInputStream) {
            LOG.debug("Checking on wrapped stream {} of {} whether is ByteBufferReadable", (Object)wrapped, (Object)stream);
            return HadoopStreams.isWrappedStreamByteBufferReadable((FSDataInputStream)wrapped);
        }
        return wrapped instanceof ByteBufferReadable;
    }

    public static PositionOutputStream wrap(FSDataOutputStream stream) {
        Objects.requireNonNull(stream, "Cannot wrap a null output stream");
        return new HadoopPositionOutputStream(stream);
    }
}

