/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hive.frequencies;

import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;

class ItemsState<T>
extends GenericUDAFEvaluator.AbstractAggregationBuffer {
    private int maxMapSize_;
    private final ArrayOfItemsSerDe<T> serDe_;
    private ItemsSketch<T> sketch;

    ItemsState(ArrayOfItemsSerDe<T> serDe) {
        this.serDe_ = serDe;
    }

    void init(int maxMapSize) {
        this.maxMapSize_ = maxMapSize;
        this.sketch = new ItemsSketch(this.maxMapSize_);
    }

    boolean isInitialized() {
        return this.sketch != null;
    }

    void update(T value) {
        this.sketch.update(value);
    }

    void update(Memory serializedSketch) {
        ItemsSketch incomingSketch = ItemsSketch.getInstance((Memory)serializedSketch, this.serDe_);
        if (this.sketch == null) {
            this.sketch = incomingSketch;
        } else {
            this.sketch.merge(incomingSketch);
        }
    }

    public ItemsSketch<T> getResult() {
        return this.sketch;
    }

    void reset() {
        this.sketch = null;
    }
}

