/*
 * Decompiled with CFR 0.152.
 */
package jodd.bean;

import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import jodd.bean.BeanUtilBean;
import jodd.bean.BeanVisitor;

public class BeanCopy {
    private final Object source;
    private Object destination;
    private boolean forced;
    private boolean declared;
    private boolean isTargetMap;
    private Predicate<String> filter;
    private BiPredicate<String, Object> filter2;
    private boolean includeFields;

    public BeanCopy(Object source, Object destination) {
        this.source = source;
        this.destination = destination;
        this.isTargetMap = destination instanceof Map;
    }

    private BeanCopy(Object source) {
        this.source = source;
    }

    public static BeanCopy from(Object source) {
        return new BeanCopy(source);
    }

    public BeanCopy to(Object destination) {
        this.destination = destination;
        this.isTargetMap = destination instanceof Map;
        return this;
    }

    public BeanCopy declared(boolean declared) {
        this.declared = declared;
        return this;
    }

    public BeanCopy forced(boolean forced) {
        this.forced = forced;
        return this;
    }

    public BeanCopy filter(Predicate<String> filter) {
        this.filter = filter;
        return this;
    }

    public BeanCopy filter(BiPredicate<String, Object> filter) {
        this.filter2 = filter;
        return this;
    }

    public BeanCopy includeFields(boolean includeFields) {
        this.includeFields = includeFields;
        return this;
    }

    public void copy() {
        BeanUtilBean beanUtil = new BeanUtilBean().declared(this.declared).forced(this.forced).silent(true);
        new BeanVisitor(this.source).declared(this.declared).includeFields(this.includeFields).visit((name, value) -> {
            if (this.isTargetMap) {
                name = "[" + name + "]";
            }
            if (this.filter != null && !this.filter.test((String)name)) {
                return;
            }
            if (this.filter2 != null && !this.filter2.test((String)name, value)) {
                return;
            }
            beanUtil.setProperty(this.destination, (String)name, value);
        });
    }
}

