/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.counters;

import java.util.concurrent.atomic.AtomicLongArray;
import org.apache.hadoop.hive.llap.counters.LlapWmCounters;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounters;

public class WmFragmentCounters {
    private State currentState = State.NONE;
    private LlapWmCounters currentCounter = null;
    private long currentCounterStartTime = 0L;
    private final AtomicLongArray fixedCounters = new AtomicLongArray(LlapWmCounters.values().length);
    private final boolean addTaskTimeCounters;

    public WmFragmentCounters(boolean addTaskTimeCounters) {
        this.addTaskTimeCounters = addTaskTimeCounters;
    }

    public void changeStateQueued(boolean isGuaranteed) {
        this.changeState(State.QUEUED, WmFragmentCounters.getQueuedCounter(isGuaranteed));
    }

    public void changeStateRunning(boolean isGuaranteed) {
        this.changeState(State.RUNNING, WmFragmentCounters.getRunningCounter(isGuaranteed));
    }

    public long getQueueTime() {
        return this.fixedCounters.get(LlapWmCounters.GUARANTEED_QUEUED_NS.ordinal()) + this.fixedCounters.get(LlapWmCounters.SPECULATIVE_QUEUED_NS.ordinal());
    }

    public long getRunningTime() {
        return this.fixedCounters.get(LlapWmCounters.GUARANTEED_RUNNING_NS.ordinal()) + this.fixedCounters.get(LlapWmCounters.SPECULATIVE_RUNNING_NS.ordinal());
    }

    private static LlapWmCounters getQueuedCounter(boolean isGuaranteed) {
        return isGuaranteed ? LlapWmCounters.GUARANTEED_QUEUED_NS : LlapWmCounters.SPECULATIVE_QUEUED_NS;
    }

    private static LlapWmCounters getRunningCounter(boolean isGuaranteed) {
        return isGuaranteed ? LlapWmCounters.GUARANTEED_RUNNING_NS : LlapWmCounters.SPECULATIVE_RUNNING_NS;
    }

    public void changeStateDone() {
        this.changeState(State.DONE, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeGuaranteed(boolean isGuaranteed) {
        long newTime = System.nanoTime();
        long oldTime = -1L;
        LlapWmCounters oldCounter = null;
        WmFragmentCounters wmFragmentCounters = this;
        synchronized (wmFragmentCounters) {
            LlapWmCounters counter = null;
            switch (this.currentState) {
                case DONE: 
                case NONE: {
                    return;
                }
                case QUEUED: {
                    counter = WmFragmentCounters.getQueuedCounter(isGuaranteed);
                    break;
                }
                case RUNNING: {
                    counter = WmFragmentCounters.getRunningCounter(isGuaranteed);
                    break;
                }
                default: {
                    throw new AssertionError((Object)this.currentState);
                }
            }
            if (counter == this.currentCounter) {
                return;
            }
            if (this.currentCounter != null) {
                oldCounter = this.currentCounter;
                oldTime = this.currentCounterStartTime;
            }
            this.currentCounter = counter;
            this.currentCounterStartTime = newTime;
        }
        if (oldCounter != null) {
            this.incrCounter(oldCounter, newTime - oldTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State newState, LlapWmCounters counter) {
        long newTime = System.nanoTime();
        long oldTime = -1L;
        LlapWmCounters oldCounter = null;
        WmFragmentCounters wmFragmentCounters = this;
        synchronized (wmFragmentCounters) {
            if (newState.ordinal() < this.currentState.ordinal()) {
                return;
            }
            if (counter == this.currentCounter) {
                return;
            }
            if (this.currentCounter != null) {
                oldCounter = this.currentCounter;
                oldTime = this.currentCounterStartTime;
            }
            this.currentCounter = counter;
            this.currentState = newState;
            this.currentCounterStartTime = newTime;
        }
        if (oldCounter != null) {
            this.incrCounter(oldCounter, newTime - oldTime);
        }
    }

    private void incrCounter(LlapWmCounters counter, long delta) {
        this.fixedCounters.addAndGet(counter.ordinal(), delta);
    }

    public void dumpToTezCounters(TezCounters tezCounters, boolean isLast) {
        if (isLast) {
            this.changeStateDone();
        }
        for (int i = 0; i < this.fixedCounters.length(); ++i) {
            tezCounters.findCounter((Enum)LlapWmCounters.values()[i]).setValue(this.fixedCounters.get(i));
        }
        if (this.addTaskTimeCounters) {
            String hostName = MetricsUtils.getHostName();
            long queued = this.fixedCounters.get(LlapWmCounters.GUARANTEED_QUEUED_NS.ordinal()) + this.fixedCounters.get(LlapWmCounters.SPECULATIVE_QUEUED_NS.ordinal());
            long running = this.fixedCounters.get(LlapWmCounters.GUARANTEED_RUNNING_NS.ordinal()) + this.fixedCounters.get(LlapWmCounters.SPECULATIVE_RUNNING_NS.ordinal());
            CounterGroup cg = (CounterGroup)tezCounters.getGroup("LlapTaskRuntimeAgg by daemon");
            cg.findCounter("QueueTime-" + hostName).setValue(queued);
            cg.findCounter("RunTime-" + hostName).setValue(running);
            cg.findCounter("Count-" + hostName).setValue(1L);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[ ");
        for (int i = 0; i < this.fixedCounters.length(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(LlapWmCounters.values()[i].name()).append("=").append(this.fixedCounters.get(i));
        }
        sb.append(" ]");
        return sb.toString();
    }

    private static enum State {
        NONE,
        QUEUED,
        RUNNING,
        DONE;

    }
}

