/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanLiteral;
import org.datanucleus.store.rdbms.sql.expression.MapLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.util.Localiser;

public class MapIsEmptyMethod
implements SQLMethod {
    @Override
    public SQLExpression getExpression(SQLStatement stmt, SQLExpression expr, List<SQLExpression> args) {
        if (args != null && args.size() > 0) {
            throw new NucleusException(Localiser.msg((String)"060015", (Object[])new Object[]{"isEmpty", "MapExpression"}));
        }
        SQLExpressionFactory exprFactory = stmt.getSQLExpressionFactory();
        if (expr instanceof MapLiteral) {
            Map map = (Map)((MapLiteral)expr).getValue();
            boolean isEmpty = map == null || map.size() == 0;
            JavaTypeMapping m = exprFactory.getMappingForType(Boolean.TYPE, false);
            return new BooleanLiteral(stmt, m, isEmpty ? Boolean.TRUE : Boolean.FALSE);
        }
        SQLExpression sizeExpr = exprFactory.invokeMethod(stmt, Map.class.getName(), "size", expr, args);
        JavaTypeMapping mapping = exprFactory.getMappingForType(Integer.class, true);
        SQLExpression zeroExpr = exprFactory.newLiteral(stmt, mapping, 0);
        return sizeExpr.eq(zeroExpr);
    }
}

