/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotTableAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotTableAction.class);
    private final TableName tableName;
    private final long sleepTime;

    public SnapshotTableAction(TableName tableName) {
        this(-1, tableName);
    }

    public SnapshotTableAction(int sleepTime, TableName tableName) {
        this.tableName = tableName;
        this.sleepTime = sleepTime;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        String snapshotName = this.tableName + "-it-" + EnvironmentEdgeManager.currentTime();
        Admin admin = util.getAdmin();
        if (this.context.isStopping()) {
            return;
        }
        this.getLogger().info("Performing action: Snapshot table {}", (Object)this.tableName);
        admin.snapshot(snapshotName, this.tableName);
        if (this.sleepTime > 0L) {
            Thread.sleep(this.sleepTime);
        }
    }
}

