/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.AbstractTestRestartCluster;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestClusterRestart
extends AbstractTestRestartCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClusterRestart.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestClusterRestart.class);

    @Override
    protected boolean splitWALCoordinatedByZk() {
        return true;
    }

    @Test
    public void test() throws Exception {
        this.UTIL.startMiniCluster(3);
        this.UTIL.waitFor(60000L, () -> this.UTIL.getMiniHBaseCluster().getMaster().isInitialized());
        LOG.info("\n\nCreating tables");
        for (TableName TABLE : TABLES) {
            this.UTIL.createTable(TABLE, FAMILY);
        }
        for (TableName TABLE : TABLES) {
            this.UTIL.waitTableEnabled(TABLE);
        }
        List allRegions = MetaTableAccessor.getAllRegions((Connection)this.UTIL.getConnection(), (boolean)false);
        Assert.assertEquals((long)4L, (long)allRegions.size());
        LOG.info("\n\nShutting down cluster");
        this.UTIL.shutdownMiniHBaseCluster();
        LOG.info("\n\nSleeping a bit");
        Thread.sleep(2000L);
        LOG.info("\n\nStarting cluster the second time");
        this.UTIL.restartHBaseCluster(3);
        allRegions = MetaTableAccessor.getAllRegions((Connection)this.UTIL.getConnection(), (boolean)false);
        Assert.assertEquals((long)4L, (long)allRegions.size());
        LOG.info("\n\nWaiting for tables to be available");
        for (TableName TABLE : TABLES) {
            try {
                this.UTIL.createTable(TABLE, FAMILY);
                Assert.assertTrue((String)"Able to create table that should already exist", (boolean)false);
            }
            catch (TableExistsException tee) {
                LOG.info("Table already exists as expected");
            }
            this.UTIL.waitTableAvailable(TABLE);
        }
    }
}

