/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.UuidComparator;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.serializer.StringSerializer;
import org.apache.directory.server.core.partition.impl.btree.mavibot.DnSerializer;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotIndex;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotTable;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotDnIndex
extends MavibotIndex<Dn, Entry> {
    private static final Logger LOG = LoggerFactory.getLogger(MavibotDnIndex.class);

    public MavibotDnIndex(RecordManager recordMan, String oid) {
        super(recordMan, oid, true);
        this.initialized = false;
    }

    @Override
    public void init(SchemaManager schemaManager, AttributeType attributeType) throws IOException {
        LOG.debug("Initializing an Index for attribute '{}'", (Object)attributeType.getName());
        this.attributeType = attributeType;
        if (this.attributeId == null) {
            this.setAttributeId(attributeType.getName());
        }
        if (this.wkDirPath == null) {
            NullPointerException e = new NullPointerException("The index working directory has not be set");
            throw e;
        }
        try {
            this.initTables(schemaManager);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        this.initialized = true;
    }

    private void initTables(SchemaManager schemaManager) throws IOException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            throw new IOException(I18n.err((I18n)I18n.ERR_574, (Object[])new Object[]{this.attributeType.getName()}));
        }
        UuidComparator.INSTANCE.setSchemaManager(schemaManager);
        DnSerializer dnSerializer = new DnSerializer();
        String forwardTableName = this.attributeType.getOid() + "_forward";
        this.forward = new MavibotTable(this.recordMan, schemaManager, forwardTableName, dnSerializer, new StringSerializer(), false);
        String reverseTableName = this.attributeType.getOid() + "_reverse";
        this.reverse = new MavibotTable(this.recordMan, schemaManager, reverseTableName, new StringSerializer(), dnSerializer, !this.attributeType.isSingleValued());
        String path = new File(this.wkDirPath, this.attributeType.getOid()).getAbsolutePath();
        FileWriter fw = new FileWriter(new File(path + "-" + this.attributeType.getName() + ".txt"));
        fw.write(this.attributeType.toString());
        fw.close();
    }
}

