/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ipc.HeapByteBufAllocator;
import org.apache.hadoop.hbase.ipc.NettyRpcFrameDecoder;
import org.apache.hadoop.hbase.ipc.NettyRpcServerPreambleHandler;
import org.apache.hadoop.hbase.ipc.NettyRpcServerRequestDecoder;
import org.apache.hadoop.hbase.ipc.NettyRpcServerResponseEncoder;
import org.apache.hadoop.hbase.ipc.NettyServerCall;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcSchedulerContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.security.HBasePolicyProvider;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.NettyEventLoopGroupConfig;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ReflectionUtils;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.io.netty.bootstrap.ServerBootstrap;
import org.apache.hbase.thirdparty.io.netty.buffer.ByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.PooledByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.buffer.UnpooledByteBufAllocator;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelHandler;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelInitializer;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelOption;
import org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.ServerChannel;
import org.apache.hbase.thirdparty.io.netty.channel.group.ChannelGroup;
import org.apache.hbase.thirdparty.io.netty.channel.group.DefaultChannelGroup;
import org.apache.hbase.thirdparty.io.netty.handler.codec.FixedLengthFrameDecoder;
import org.apache.hbase.thirdparty.io.netty.util.concurrent.GlobalEventExecutor;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class NettyRpcServer
extends RpcServer {
    public static final Logger LOG = LoggerFactory.getLogger(NettyRpcServer.class);
    public static final String HBASE_NETTY_ALLOCATOR_KEY = "hbase.netty.rpcserver.allocator";
    static final String POOLED_ALLOCATOR_TYPE = "pooled";
    static final String UNPOOLED_ALLOCATOR_TYPE = "unpooled";
    static final String HEAP_ALLOCATOR_TYPE = "heap";
    private final InetSocketAddress bindAddress;
    private final CountDownLatch closed = new CountDownLatch(1);
    private final Channel serverChannel;
    final ChannelGroup allChannels = new DefaultChannelGroup(GlobalEventExecutor.INSTANCE, true);
    private final ByteBufAllocator channelAllocator;

    public NettyRpcServer(Server server, String name, List<RpcServer.BlockingServiceAndInterface> services, InetSocketAddress bindAddress, Configuration conf, RpcScheduler scheduler, boolean reservoirEnabled) throws IOException {
        super(server, name, services, bindAddress, conf, scheduler, reservoirEnabled);
        this.bindAddress = bindAddress;
        this.channelAllocator = this.getChannelAllocator(conf);
        NettyEventLoopGroupConfig config = null;
        if (server instanceof HRegionServer) {
            config = ((HRegionServer)server).getEventLoopGroupConfig();
        }
        if (config == null) {
            config = new NettyEventLoopGroupConfig(conf, "NettyRpcServer");
        }
        EventLoopGroup eventLoopGroup = config.group();
        Class<? extends ServerChannel> channelClass = config.serverChannelClass();
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group(eventLoopGroup).channel(channelClass)).childOption(ChannelOption.TCP_NODELAY, this.tcpNoDelay).childOption(ChannelOption.SO_KEEPALIVE, this.tcpKeepAlive).childOption(ChannelOption.SO_REUSEADDR, true).childHandler(new ChannelInitializer<Channel>(){

            @Override
            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator(NettyRpcServer.this.channelAllocator);
                ChannelPipeline pipeline = ch.pipeline();
                FixedLengthFrameDecoder preambleDecoder = new FixedLengthFrameDecoder(6);
                preambleDecoder.setSingleDecode(true);
                pipeline.addLast("preambleDecoder", (ChannelHandler)preambleDecoder);
                pipeline.addLast("preambleHandler", (ChannelHandler)NettyRpcServer.this.createNettyRpcServerPreambleHandler());
                pipeline.addLast("frameDecoder", (ChannelHandler)new NettyRpcFrameDecoder(NettyRpcServer.this.maxRequestSize));
                pipeline.addLast("decoder", (ChannelHandler)new NettyRpcServerRequestDecoder(NettyRpcServer.this.allChannels, NettyRpcServer.this.metrics));
                pipeline.addLast("encoder", (ChannelHandler)new NettyRpcServerResponseEncoder(NettyRpcServer.this.metrics));
            }
        });
        try {
            this.serverChannel = bootstrap.bind(this.bindAddress).sync().channel();
            LOG.info("Bind to {}", (Object)this.serverChannel.localAddress());
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        this.initReconfigurable(conf);
        this.scheduler.init(new RpcSchedulerContext(this));
    }

    private ByteBufAllocator getChannelAllocator(Configuration conf) throws IOException {
        String value = conf.get(HBASE_NETTY_ALLOCATOR_KEY);
        if (value != null) {
            if (POOLED_ALLOCATOR_TYPE.equalsIgnoreCase(value)) {
                LOG.info("Using {} for buffer allocation", (Object)PooledByteBufAllocator.class.getName());
                return PooledByteBufAllocator.DEFAULT;
            }
            if (UNPOOLED_ALLOCATOR_TYPE.equalsIgnoreCase(value)) {
                LOG.info("Using {} for buffer allocation", (Object)UnpooledByteBufAllocator.class.getName());
                return UnpooledByteBufAllocator.DEFAULT;
            }
            if (HEAP_ALLOCATOR_TYPE.equalsIgnoreCase(value)) {
                LOG.info("Using {} for buffer allocation", (Object)HeapByteBufAllocator.class.getName());
                return HeapByteBufAllocator.DEFAULT;
            }
            try {
                ByteBufAllocator alloc = (ByteBufAllocator)ReflectionUtils.newInstance(value, new Object[0]);
                LOG.info("Using {} for buffer allocation", (Object)value);
                return alloc;
            }
            catch (ClassCastException | UnsupportedOperationException e) {
                throw new IOException(e);
            }
        }
        LOG.info("Using {} for buffer allocation", (Object)PooledByteBufAllocator.class.getName());
        return PooledByteBufAllocator.DEFAULT;
    }

    @InterfaceAudience.Private
    protected NettyRpcServerPreambleHandler createNettyRpcServerPreambleHandler() {
        return new NettyRpcServerPreambleHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.authTokenSecretMgr = this.createSecretManager();
        if (this.authTokenSecretMgr != null) {
            AuthenticationTokenSecretManager authenticationTokenSecretManager = this.authTokenSecretMgr;
            synchronized (authenticationTokenSecretManager) {
                this.setSecretManager(this.authTokenSecretMgr);
                this.authTokenSecretMgr.start();
            }
        }
        this.authManager = new ServiceAuthorizationManager();
        HBasePolicyProvider.init(this.conf, this.authManager);
        this.scheduler.start();
        this.started = true;
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        LOG.info("Stopping server on " + this.serverChannel.localAddress());
        if (this.authTokenSecretMgr != null) {
            this.authTokenSecretMgr.stop();
            this.authTokenSecretMgr = null;
        }
        this.allChannels.close().awaitUninterruptibly();
        this.serverChannel.close();
        this.scheduler.stop();
        this.closed.countDown();
        this.running = false;
    }

    @Override
    public synchronized void join() throws InterruptedException {
        this.closed.await();
    }

    @Override
    public synchronized InetSocketAddress getListenerAddress() {
        return (InetSocketAddress)this.serverChannel.localAddress();
    }

    @Override
    public void setSocketSendBufSize(int size) {
    }

    @Override
    public int getNumOpenConnections() {
        return this.allChannels.size();
    }

    @Override
    public Pair<Message, CellScanner> call(BlockingService service, Descriptors.MethodDescriptor md, Message param, CellScanner cellScanner, long receiveTime, MonitoredRPCHandler status) throws IOException {
        return this.call(service, md, param, cellScanner, receiveTime, status, EnvironmentEdgeManager.currentTime(), 0);
    }

    @Override
    public Pair<Message, CellScanner> call(BlockingService service, Descriptors.MethodDescriptor md, Message param, CellScanner cellScanner, long receiveTime, MonitoredRPCHandler status, long startTime, int timeout) throws IOException {
        NettyServerCall fakeCall = new NettyServerCall(-1, service, md, null, param, cellScanner, null, -1L, null, receiveTime, timeout, this.bbAllocator, this.cellBlockBuilder, null);
        return this.call(fakeCall, status);
    }
}

