/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.gson;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.apache.hbase.thirdparty.javax.ws.rs.Produces;
import org.apache.hbase.thirdparty.javax.ws.rs.WebApplicationException;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MediaType;
import org.apache.hbase.thirdparty.javax.ws.rs.core.MultivaluedMap;
import org.apache.hbase.thirdparty.javax.ws.rs.ext.MessageBodyWriter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@Produces(value={"application/json"})
public final class GsonMessageBodyWriter<T>
implements MessageBodyWriter<T> {
    private static final Logger logger = LoggerFactory.getLogger(GsonMessageBodyWriter.class);
    private final Gson gson;

    @Inject
    public GsonMessageBodyWriter(Gson gson) {
        this.gson = gson;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return mediaType == null || MediaType.APPLICATION_JSON_TYPE.isCompatible(mediaType);
    }

    @Override
    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        Charset outputCharset = GsonMessageBodyWriter.requestedCharset(mediaType);
        try (OutputStreamWriter writer = new OutputStreamWriter(entityStream, outputCharset);){
            this.gson.toJson(t, (Appendable)writer);
        }
    }

    private static Charset requestedCharset(MediaType mediaType) {
        return Optional.ofNullable(mediaType).map(MediaType::getParameters).map(params -> (String)params.get("charset")).map(c -> {
            try {
                return Charset.forName(c);
            }
            catch (IllegalCharsetNameException e) {
                logger.debug("Client requested illegal Charset '{}'", c);
                return null;
            }
            catch (UnsupportedCharsetException e) {
                logger.debug("Client requested unsupported Charset '{}'", c);
                return null;
            }
            catch (Exception e) {
                logger.debug("Error while resolving Charset '{}'", c, (Object)e);
                return null;
            }
        }).orElse(StandardCharsets.UTF_8);
    }
}

