/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.FeedOptionsBase;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

class Fetcher<T extends Resource> {
    private static final Logger logger = LoggerFactory.getLogger(Fetcher.class);
    private final Func2<String, Integer, RxDocumentServiceRequest> createRequestFunc;
    private final Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeFunc;
    private final boolean isChangeFeed;
    private volatile boolean shouldFetchMore;
    private volatile int maxItemCount;
    private volatile int top;
    private volatile String continuationToken;

    public Fetcher(Func2<String, Integer, RxDocumentServiceRequest> createRequestFunc, Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeFunc, FeedOptionsBase options, boolean isChangeFeed, int top, int maxItemCount) {
        this.createRequestFunc = createRequestFunc;
        this.executeFunc = executeFunc;
        this.isChangeFeed = isChangeFeed;
        this.continuationToken = options.getRequestContinuation();
        this.top = top;
        this.maxItemCount = top == -1 ? maxItemCount : Math.min(maxItemCount, top);
        this.shouldFetchMore = true;
    }

    public boolean shouldFetchMore() {
        return this.shouldFetchMore;
    }

    public Observable<FeedResponse<T>> nextPage() {
        RxDocumentServiceRequest request = this.createRequest();
        return this.nextPage(request);
    }

    private void updateState(FeedResponse<T> response) {
        this.continuationToken = response.getResponseContinuation();
        if (this.top != -1) {
            this.top -= response.getResults().size();
            if (this.top < 0) {
                logger.warn("Azure Cosmos DB BackEnd Service returned more than requested {} items", (Object)this.maxItemCount);
                this.top = 0;
            }
            this.maxItemCount = Math.min(this.maxItemCount, this.top);
        }
        this.shouldFetchMore = this.shouldFetchMore && !StringUtils.isEmpty((CharSequence)this.continuationToken) && this.top != 0 && (!this.isChangeFeed || !BridgeInternal.noChanges(response));
        logger.debug("Fetcher state updated: isChangeFeed = {}, continuation token = {}, max item count = {}, should fetch more = {}", new Object[]{this.isChangeFeed, this.continuationToken, this.maxItemCount, this.shouldFetchMore});
    }

    private RxDocumentServiceRequest createRequest() {
        if (!this.shouldFetchMore) {
            logger.error("invalid state, trying to fetch more after completion");
            throw new IllegalStateException("Invalid state, trying to fetch more after completion");
        }
        return (RxDocumentServiceRequest)this.createRequestFunc.call((Object)this.continuationToken, (Object)this.maxItemCount);
    }

    private Observable<FeedResponse<T>> nextPage(RxDocumentServiceRequest request) {
        return ((Observable)this.executeFunc.call((Object)request)).map(rsp -> {
            this.updateState((FeedResponse<T>)rsp);
            return rsp;
        });
    }
}

